/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;

public abstract class NodeHandler {
    private static final String VISITED = "visited";

    public static String getLoopFlag(String nodeName) {
        return nodeName + "#" + VISITED;
    }

    public void loopDetection(Context context) throws WorkflowException {
        String flag = NodeHandler.getLoopFlag(context.getNodeDef().getName());
        if (context.getVar(flag) != null) {
            throw new WorkflowException(ErrorCode.E0709, context.getNodeDef().getName());
        }
        context.setVar(flag, "true");
    }

    public abstract boolean enter(Context var1) throws WorkflowException;

    public List<String> multiExit(Context context) throws WorkflowException {
        ArrayList<String> transitions = new ArrayList<String>(1);
        String transition = this.exit(context);
        if (transition != null) {
            transitions.add(context.createFullTransition(context.getExecutionPath(), transition));
        }
        return transitions;
    }

    public abstract String exit(Context var1) throws WorkflowException;

    public void kill(Context context) {
    }

    public void fail(Context context) {
    }

    public static interface Context {
        public NodeDef getNodeDef();

        public String getExecutionPath();

        public String getParentExecutionPath(String var1);

        public String getSignalValue();

        public void setVar(String var1, String var2);

        public String getVar(String var1);

        public void setTransientVar(String var1, Object var2);

        public Object getTransientVar(String var1);

        public String createExecutionPath(String var1);

        public void deleteExecutionPath();

        public String createFullTransition(String var1, String var2);

        public void killJob();

        public void completeJob();

        public LiteWorkflowInstance getProcessInstance();
    }
}

