/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.oozie.coord.TimeUnit;

public class DateUtils {
    private static final String[] W3CDATETIME_MASKS = new String[]{"yyyy-MM-dd'T'HH:mmz"};
    private static final TimeZone UTC = DateUtils.getTimeZone("UTC");

    private static Date parseUsingMask(String[] masks, String sDate) {
        sDate = sDate != null ? sDate.trim() : null;
        Date d = null;
        if (sDate != null) {
            for (int i = 0; d == null && i < masks.length; ++i) {
                SimpleDateFormat df = new SimpleDateFormat(masks[i], Locale.US);
                df.setLenient(true);
                ParsePosition pp = new ParsePosition(0);
                d = ((DateFormat)df).parse(sDate, pp);
                if (pp.getIndex() == sDate.length()) continue;
                d = null;
            }
        }
        return d;
    }

    private static DateFormat getISO8601DateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(UTC);
        return dateFormat;
    }

    private static DateFormat getSpecificDateFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(UTC);
        return dateFormat;
    }

    public static TimeZone getTimeZone(String tzId) {
        if (tzId == null) {
            throw new IllegalArgumentException("Invalid TimeZone: " + tzId);
        }
        TimeZone tz = TimeZone.getTimeZone(tzId);
        if (!tz.getID().equals(tzId)) {
            throw new IllegalArgumentException("Invalid TimeZone: " + tzId);
        }
        return tz;
    }

    public static Date parseDateUTC(String s) throws Exception {
        return DateUtils.getISO8601DateFormat().parse(s);
    }

    public static String formatDateUTC(Date d) throws Exception {
        return d != null ? DateUtils.getISO8601DateFormat().format(d) : "NULL";
    }

    public static String formatDateCustom(Date d, String format) throws Exception {
        return d != null ? DateUtils.getSpecificDateFormat(format).format(d) : "NULL";
    }

    public static String formatDateUTC(Calendar c) throws Exception {
        return c != null ? DateUtils.formatDateUTC(c.getTime()) : "NULL";
    }

    public static int hoursInDay(Calendar cal) {
        GregorianCalendar localCal = new GregorianCalendar(cal.getTimeZone());
        localCal.set(14, 0);
        localCal.set(cal.get(1), cal.get(2), cal.get(5), 0, 30, 0);
        ((Calendar)localCal).add(11, 24);
        switch (localCal.get(11)) {
            case 1: {
                return 23;
            }
            case 23: {
                return 25;
            }
        }
        return 24;
    }

    public static boolean isDSTChangeDay(Calendar cal) {
        return DateUtils.hoursInDay(cal) != 24;
    }

    public static void moveToEnd(Calendar cal, TimeUnit endOfFlag) {
        if (endOfFlag == TimeUnit.END_OF_DAY) {
            cal.add(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        } else if (endOfFlag == TimeUnit.END_OF_MONTH) {
            cal.add(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
    }

    public static Calendar getCalendar(String dateString, TimeZone tz) throws Exception {
        Date date = DateUtils.parseDateUTC(dateString);
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(date);
        calDate.setTimeZone(tz);
        return calDate;
    }

    public static Calendar getCalendar(String dateString) throws Exception {
        return DateUtils.getCalendar(dateString, DateUtils.getTimeZone("UTC"));
    }

    public static Date toDate(Timestamp timestamp) {
        if (timestamp != null) {
            long milliseconds = timestamp.getTime();
            return new Date(milliseconds);
        }
        return null;
    }

    public static Timestamp convertDateToTimestamp(Date d) {
        if (d != null) {
            return new Timestamp(d.getTime());
        }
        return null;
    }

    public static String convertDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String convertDateToString(long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date(timeStamp));
    }
}

