/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.local;

import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.DagEngine;
import org.apache.oozie.LocalOozieClient;
import org.apache.oozie.LocalOozieClientCoord;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.CallbackServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class LocalOozie {
    private static EmbeddedServletContainer container;
    private static boolean localOozieActive;

    public static synchronized void start() throws Exception {
        if (localOozieActive) {
            throw new IllegalStateException("LocalOozie is already initialized");
        }
        String log4jFile = System.getProperty("oozie.log4j.file", null);
        String oozieLocalLog = System.getProperty("oozielocal.log", null);
        if (log4jFile == null) {
            System.setProperty("oozie.log4j.file", "localoozie-log4j.properties");
        }
        if (oozieLocalLog == null) {
            System.setProperty("oozielocal.log", "./oozielocal.log");
        }
        localOozieActive = true;
        new Services().init();
        if (log4jFile != null) {
            System.setProperty("oozie.log4j.file", log4jFile);
        } else {
            System.getProperties().remove("oozie.log4j.file");
        }
        if (oozieLocalLog != null) {
            System.setProperty("oozielocal.log", oozieLocalLog);
        } else {
            System.getProperties().remove("oozielocal.log");
        }
        container = new EmbeddedServletContainer("oozie");
        container.addServletEndpoint("/callback", CallbackServlet.class);
        container.start();
        String callbackUrl = container.getServletURL("/callback");
        Services.get().getConf().set("oozie.service.CallbackService.base.url", callbackUrl);
        XLog.getLog(LocalOozie.class).info("LocalOozie started callback set to [{0}]", callbackUrl);
    }

    public static synchronized void stop() {
        RuntimeException thrown;
        block6: {
            thrown = null;
            try {
                if (container != null) {
                    container.stop();
                }
            }
            catch (RuntimeException ex) {
                thrown = ex;
            }
            container = null;
            XLog.getLog(LocalOozie.class).info("LocalOozie stopped");
            try {
                Services.get().destroy();
            }
            catch (RuntimeException ex) {
                if (thrown == null) break block6;
                thrown = ex;
            }
        }
        localOozieActive = false;
        if (thrown != null) {
            throw thrown;
        }
    }

    public static OozieClient getClient() {
        return LocalOozie.getClient(System.getProperty("user.name"));
    }

    public static OozieClient getCoordClient() {
        return LocalOozie.getClientCoord(System.getProperty("user.name"));
    }

    public static OozieClient getClient(String user) {
        if (!localOozieActive) {
            throw new IllegalStateException("LocalOozie is not initialized");
        }
        ParamChecker.notEmpty(user, "user");
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user, "undef");
        return new LocalOozieClient(dagEngine);
    }

    public static OozieClient getClientCoord(String user) {
        if (!localOozieActive) {
            throw new IllegalStateException("LocalOozie is not initialized");
        }
        ParamChecker.notEmpty(user, "user");
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(user, "undef");
        return new LocalOozieClientCoord(coordEngine);
    }

    static {
        localOozieActive = false;
    }
}

