/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionEndCommand;
import org.apache.oozie.command.wf.ActionStartCommand;
import org.apache.oozie.command.wf.KillCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class ResumeCommand
extends WorkflowCommand<Void> {
    private String id;

    public ResumeCommand(String id) {
        super("resume", "resume", 1, 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        try {
            WorkflowJobBean workflow = store.getWorkflow(this.id, false);
            this.setLogInfo(workflow);
            if (workflow.getStatus() == WorkflowJob.Status.SUSPENDED) {
                this.incrJobCounter(1);
                workflow.getWorkflowInstance().resume();
                WorkflowInstance wfInstance = workflow.getWorkflowInstance();
                ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.RUNNING);
                workflow.setWorkflowInstance(wfInstance);
                workflow.setStatus(WorkflowJob.Status.RUNNING);
                for (WorkflowActionBean action : store.getActionsForWorkflow(this.id, false)) {
                    Date nextRunTime;
                    if (action.isRetryOrManual()) {
                        action.setPendingOnly();
                        store.updateAction(action);
                    }
                    if (!action.isPending()) continue;
                    if (action.getStatus() == WorkflowAction.Status.PREP || action.getStatus() == WorkflowAction.Status.START_MANUAL) {
                        this.queueCallable(new ActionStartCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.START_RETRY) {
                        nextRunTime = action.getPendingAge();
                        this.queueCallable(new ActionStartCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.DONE || action.getStatus() == WorkflowAction.Status.END_MANUAL) {
                        this.queueCallable(new ActionEndCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() != WorkflowAction.Status.END_RETRY) continue;
                    nextRunTime = action.getPendingAge();
                    this.queueCallable(new ActionEndCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                }
                store.updateWorkflow(workflow);
                this.queueCallable(new NotificationCommand(workflow));
            }
            return null;
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        XLog.getLog(this.getClass()).debug("STARTED ResumeCommand for action " + this.id);
        try {
            if (this.lock(this.id)) {
                this.call(store);
            } else {
                this.queueCallable(new KillCommand(this.id), 30000L);
                XLog.getLog(this.getClass()).warn("Resume lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new KillCommand(this.id), 30000L);
            XLog.getLog(this.getClass()).warn("ResumeCommand lock was not acquired - interrupted exception failed {0}", this.id);
        }
        finally {
            XLog.getLog(this.getClass()).debug("ENDED ResumeCommand for action " + this.id);
        }
        return null;
    }
}

