/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.XLog;

public class CoordRecoveryCommand
extends CoordinatorCommand<Void> {
    private final XLog log = XLog.getLog(this.getClass());
    private String jobId;

    public CoordRecoveryCommand(String id) {
        super("coord_recovery", "coord_recovery", 1, 1);
        this.jobId = id;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException {
        CoordinatorJobBean coordJob = (CoordinatorJobBean)store.getEntityManager().find(CoordinatorJobBean.class, (Object)this.jobId);
        this.setLogInfo(coordJob);
        if (coordJob.getStatus() == Job.Status.PREMATER) {
            coordJob.setStatus(Job.Status.RUNNING);
            store.updateCoordinatorJob(coordJob);
            this.log.debug("[" + this.jobId + "]: Recover status from PREMATER to RUNNING");
        } else {
            this.log.debug("[" + this.jobId + "]: already in non-PREMATER status");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordRecoveryCommand for jobId=" + this.jobId);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordRecoveryCommand(this.jobId), 30000L);
                this.log.warn("CoordRecoveryCommand lock was not acquired - failed jobId=" + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordRecoveryCommand(this.jobId), 30000L);
            this.log.warn("CoordRecoveryCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.jobId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordRecoveryCommand for jobId=" + this.jobId);
        }
        return null;
    }
}

