/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionsSubsetGetForJobJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class CoordJobXCommand
extends CoordinatorXCommand<CoordinatorJobBean> {
    private final String id;
    private final boolean getActionInfo;
    private int start = 1;
    private int len = Integer.MAX_VALUE;

    public CoordJobXCommand(String id) {
        this(id, 1, Integer.MAX_VALUE);
    }

    public CoordJobXCommand(String id, int start, int length) {
        super("job.info", "job.info", 1);
        this.id = ParamChecker.notEmpty(id, "id");
        this.getActionInfo = true;
        this.start = start;
        this.len = length;
    }

    public CoordJobXCommand(String id, boolean getActionInfo) {
        super("job.info", "job.info", 1);
        this.id = ParamChecker.notEmpty(id, "id");
        this.getActionInfo = getActionInfo;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected String getEntityKey() {
        return this.id;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected CoordinatorJobBean execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            CoordinatorJobBean coordJob = null;
            if (jpaService != null) {
                coordJob = jpaService.execute(new CoordJobGetJPAExecutor(this.id));
                if (this.getActionInfo) {
                    List<CoordinatorActionBean> coordActions = jpaService.execute(new CoordActionsSubsetGetForJobJPAExecutor(this.id, this.start, this.len));
                    coordJob.setActions(coordActions);
                }
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
            return coordJob;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }
}

