/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobCommand
extends CoordinatorCommand<CoordinatorJobBean> {
    private String id;
    private boolean getActionInfo;
    private int start = 1;
    private int len = Integer.MAX_VALUE;

    public CoordJobCommand(String id) {
        this(id, 1, Integer.MAX_VALUE);
    }

    public CoordJobCommand(String id, int start, int length) {
        super("job.info", "job.info", 1, 4);
        this.id = ParamChecker.notEmpty(id, "id");
        this.getActionInfo = true;
        this.start = start;
        this.len = length;
    }

    public CoordJobCommand(String id, boolean getActionInfo) {
        super("job.info", "job.info", 1, 4);
        this.id = ParamChecker.notEmpty(id, "id");
        this.getActionInfo = getActionInfo;
    }

    @Override
    protected CoordinatorJobBean call(CoordinatorStore store) throws StoreException, CommandException {
        CoordinatorJobBean coord = store.getCoordinatorJob(this.id, false);
        if (this.getActionInfo) {
            coord.setActions(store.getActionsSubsetForCoordinatorJob(this.id, this.start, this.len));
        } else {
            coord.setActions(null);
        }
        return coord;
    }
}

