/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionTimeOutXCommand
extends CoordinatorXCommand<Void> {
    private CoordinatorActionBean actionBean;
    private JPAService jpaService = null;

    public CoordActionTimeOutXCommand(CoordinatorActionBean actionBean) {
        super("coord_action_timeout", "coord_action_timeout", 1);
        ParamChecker.notNull(actionBean, "ActionBean");
        this.actionBean = actionBean;
    }

    @Override
    protected Void execute() throws CommandException {
        if (this.actionBean.getStatus() == CoordinatorAction.Status.WAITING) {
            this.actionBean.setStatus(CoordinatorAction.Status.TIMEDOUT);
            this.queue(new CoordActionNotificationXCommand(this.actionBean), 100L);
            this.actionBean.setLastModifiedTime(new Date());
            try {
                this.jpaService.execute(new CoordActionUpdateJPAExecutor(this.actionBean));
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return this.actionBean.getJobId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.actionBean = this.jpaService.execute(new CoordActionGetJPAExecutor(this.actionBean.getId()));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.actionBean, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.actionBean.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, new Object[0]);
        }
    }
}

