/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.common;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.trans.steps.common.BaseComposite;

public class GroupComposite
extends BaseComposite {
    private ComboVar wGroups;
    private Label bAddGroup;
    private Label bCopyGroup;

    public GroupComposite(Composite parent, VariableSpace variables) {
        super(parent, 0);
        this.setVariables(variables);
        this.init();
    }

    protected void init() {
        this.setDefaultRowLayout();
    }

    public void createWidgets() {
        Composite wLinkedComposite = new Composite((Composite)this, 0);
        RowLayout linkedLayout = new RowLayout();
        linkedLayout.marginLeft = 0;
        linkedLayout.marginRight = 0;
        linkedLayout.marginBottom = 0;
        linkedLayout.marginTop = 0;
        wLinkedComposite.setLayout((Layout)linkedLayout);
        this.setLook((Control)wLinkedComposite);
        this.wGroups = new ComboVar(this.getVariables(), wLinkedComposite, 2048);
        RowData rowData = new RowData();
        rowData.width = 300;
        this.wGroups.setLayoutData((Object)rowData);
        this.setLook((Control)this.wGroups);
        Label spacer1 = new Label(wLinkedComposite, 0x800000);
        spacer1.setLayoutData((Object)new RowData(5, 0));
        this.bAddGroup = new Label(wLinkedComposite, 0x800000);
        this.bAddGroup.setImage(GUIResource.getInstance().getImageAdd());
        this.bAddGroup.setToolTipText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.AddGroup.ToolTip", (String[])new String[0]));
        this.setLook((Control)this.bAddGroup);
        Label spacer2 = new Label(wLinkedComposite, 0x800000);
        spacer2.setLayoutData((Object)new RowData(5, 0));
        this.bCopyGroup = new Label(wLinkedComposite, 0x800000);
        this.bCopyGroup.setImage(GUIResource.getInstance().getImageCopyHop());
        this.bCopyGroup.setToolTipText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.CopyGroup.ToolTip", (String[])new String[0]));
        this.setLook((Control)this.bCopyGroup);
    }

    public void setEnableAddCopyButtons(boolean enable) {
        this.bAddGroup.setEnabled(enable);
        this.bAddGroup.setImage(new Image((Device)this.getParent().getDisplay(), GUIResource.getInstance().getImageAdd(), enable ? 0 : 1));
        this.bCopyGroup.setEnabled(enable);
        this.bCopyGroup.setImage(new Image((Device)this.getParent().getDisplay(), GUIResource.getInstance().getImageCopyHop(), enable ? 0 : 1));
    }

    public ComboVar getGroupComboWidget() {
        return this.wGroups;
    }

    public void setAddGroupListener(Listener listener) {
        this.bAddGroup.addListener(4, listener);
    }

    public void setCopyGroupListener(Listener listener) {
        this.bCopyGroup.addListener(4, listener);
    }

    public void setAddGroupTooltip(String message) {
        this.bAddGroup.setToolTipText(message);
    }

    public void setCopyGroupTooltip(String message) {
        this.bCopyGroup.setToolTipText(message);
    }

    public void setEnabled(boolean enabled) {
        this.wGroups.setEnabled(enabled);
        this.setEnableAddCopyButtons(enabled);
    }
}

