/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.build;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.refinery.UIBuilder;
import org.pentaho.di.core.refinery.model.ModelServerFetcher;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.JobEntryDialogBoilerplate;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.job.entries.common.ConnectionValidator;
import org.pentaho.di.ui.job.entries.common.ServerConnectionGroupWrapper;

public class SelectModelDialog
extends JobEntryDialogBoilerplate<JobEntryBuildModel>
implements JobEntryDialogInterface {
    private static final Pattern varRegex = Pattern.compile("\\$\\{[^}]*\\}");
    private final int SHELL_MIN_WIDTH = 470;
    private Label wlChooseModel;
    private ComboVar wChooseModel;
    private Button bCreateOnPublish;
    private ServerConnectionGroupWrapper serverConnectionGroupWrapper;

    public SelectModelDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntry, rep, jobMeta);
        this.PKG = JobEntryBuildModel.class;
    }

    protected Group createServerConnectionGroup(Composite main) {
        this.serverConnectionGroupWrapper = new ServerConnectionGroupWrapper(main, this.props, this.jobMeta, this.jobEntry, this.PKG);
        this.serverConnectionGroupWrapper.addSubmitButtonListener(new Listener(){

            public void handleEvent(Event event) {
                BiServerConnection biServerConnection = SelectModelDialog.this.serverConnectionGroupWrapper.getBiServerConnection(true);
                ConnectionValidator connectionValidator = new ConnectionValidator();
                connectionValidator.setSuppressSuccessMessage(true);
                connectionValidator.setConnection(biServerConnection);
                if (!connectionValidator.validateConnectionInDesignTime()) {
                    SelectModelDialog.this.wChooseModel.removeAll();
                    return;
                }
                ModelServerFetcher fetcher = new ModelServerFetcher(biServerConnection);
                try {
                    List<String> datasourceList = fetcher.fetchDswList();
                    datasourceList.addAll(fetcher.fetchAnalysisList());
                    Collections.sort(datasourceList);
                    String prevSelection = SelectModelDialog.this.wChooseModel.getText();
                    SelectModelDialog.this.wChooseModel.removeAll();
                    for (String datasource : datasourceList) {
                        SelectModelDialog.this.wChooseModel.add(datasource);
                    }
                    if (datasourceList.contains(prevSelection)) {
                        SelectModelDialog.this.wChooseModel.select(datasourceList.indexOf(prevSelection));
                    } else if (varRegex.matcher(prevSelection).find()) {
                        SelectModelDialog.this.wChooseModel.setText(prevSelection);
                        SelectModelDialog.this.wChooseModel.getCComboWidget().setSelection(new Point(0, 0));
                    } else {
                        SelectModelDialog.this.wChooseModel.select(0);
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(SelectModelDialog.this.shell, "Error", "Error retrieving data sources", e);
                }
            }
        });
        return this.serverConnectionGroupWrapper.getGroup();
    }

    protected Composite createModelComposite(Composite main) {
        Composite composite = UIBuilder.createFormComposite(main);
        this.props.setLook((Control)composite);
        this.wlChooseModel = new Label(composite, 131072);
        this.wlChooseModel.setText(this.getMsg("SelectModelDialog.ChooseModel.Label"));
        this.props.setLook((Control)this.wlChooseModel);
        this.wChooseModel = new ComboVar((VariableSpace)this.jobMeta, composite, 18432);
        this.wChooseModel.setItems(new String[]{""});
        this.wChooseModel.setToolTipText(this.getMsg("SelectModelDialog.ChooseModel.Label"));
        this.wChooseModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SelectModelDialog.this.wChooseModel.getText() != null && (SelectModelDialog.this.wChooseModel.getText().endsWith(".xmi") || SelectModelDialog.this.wChooseModel.getText().startsWith("${"))) {
                    SelectModelDialog.this.bCreateOnPublish.setEnabled(true);
                } else {
                    SelectModelDialog.this.bCreateOnPublish.setEnabled(false);
                    SelectModelDialog.this.bCreateOnPublish.setSelection(false);
                }
            }
        });
        this.wChooseModel.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                SelectModelDialog.this.wChooseModel.getCComboWidget().setSelection(new Point(0, 0));
            }
        });
        this.props.setLook((Control)this.wChooseModel);
        this.bCreateOnPublish = new Button(composite, 32);
        this.bCreateOnPublish.setText(this.getMsg("SelectModelDialog.CreateOnPublish.Label"));
        this.bCreateOnPublish.setToolTipText(this.getMsg("SelectModelDialog.CreateOnPublish.Label"));
        this.props.setLook((Control)this.bCreateOnPublish);
        UIBuilder.positionLabelInputPairBelow(this.wlChooseModel, (Control)this.wChooseModel, null, 0);
        ((FormData)this.wChooseModel.getLayoutData()).width = 250;
        UIBuilder.positionControlBelow((Control)this.bCreateOnPublish, (Control)this.wChooseModel, 15);
        ((FormLayout)composite.getLayout()).marginBottom = 15;
        return composite;
    }

    @Override
    protected void createControls(Shell shell, Control topControl, Control bottomControl, Composite main) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        main.setLayout((Layout)layout);
        Group serverGroup = this.createServerConnectionGroup(main);
        UIBuilder.positionControlBelow((Control)serverGroup, null, 5);
        ((FormData)serverGroup.getLayoutData()).right = new FormAttachment(100, -4);
        Composite modelComposite = this.createModelComposite(main);
        UIBuilder.positionControlBelow((Control)modelComposite, (Control)serverGroup, 10);
        int height = this.getMinHeight((Composite)shell);
        shell.setMinimumSize(470, height);
        shell.setSize(470, height);
    }

    @Override
    protected boolean hasEntryNameHeader() {
        return false;
    }

    @Override
    protected void loadData(JobEntryBuildModel jobEntry) {
        super.loadData(jobEntry);
        if (jobEntry.getBiServerConnection() != null) {
            this.serverConnectionGroupWrapper.setBiServerConnection(jobEntry.getBiServerConnection());
        }
        if (StringUtils.isNotBlank((String)jobEntry.getSelectedModel())) {
            this.wChooseModel.setText(jobEntry.getSelectedModel());
            this.wChooseModel.getCComboWidget().setSelection(new Point(0, 0));
        }
        this.bCreateOnPublish.setSelection(jobEntry.isCreateOnPublish());
    }

    @Override
    protected void saveData(JobEntryBuildModel jobEntry) {
        super.saveData(jobEntry);
        BiServerConnection biServerConnection = this.serverConnectionGroupWrapper.getBiServerConnection(false);
        jobEntry.setBiServerConnection(biServerConnection);
        jobEntry.setSelectedModel(this.wChooseModel.getText());
        jobEntry.setCreateOnPublish(this.bCreateOnPublish.getSelection());
    }

    @Override
    protected String getTitle() {
        return this.getMsg("SelectModelDialog.Title");
    }

    protected BiServerConnection getBIServerConnection() {
        return this.serverConnectionGroupWrapper.getBiServerConnection(true);
    }

    @Override
    protected String getJobIcon() {
        return "ui/model_entry.png";
    }
}

