/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.util;

import com.sun.jersey.api.client.ClientResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.model.ResponseStatus;
import org.pentaho.di.core.refinery.publish.util.BaseRestUtil;

public class PublishRestUtil
extends BaseRestUtil {
    protected static final String CAN_PUBLISH_PATH = "api/authorization/action/isauthorized?authAction=org.pentaho.security.publish";
    protected static final String CAN_CREATE_PATH = "api/authorization/action/isauthorized?authAction=org.pentaho.repository.create";
    protected static final String CAN_EXECUTE_PATH = "api/authorization/action/isauthorized?authAction=org.pentaho.repository.execute";
    protected static final String CAN_MANAGE_DATASOURCES = "api/authorization/action/isauthorized?authAction=org.pentaho.platform.dataaccess.datasource.security.manage";
    protected static final String PENTAHO_WEBCONTEXT_PATH = "webcontext.js";
    protected static final String PENTAHO_WEBCONTEXT_MATCH = "PentahoWebContextFilter";
    protected static final String SUCCESS_RESPONSE = "SUCCESS";
    private Log logger = LogFactory.getLog(PublishRestUtil.class);
    protected int lastHTTPStatus = 0;

    public boolean isUnauthenticatedUser(BiServerConnection connection) {
        ResponseStatus response = this.simpleHttpGet(connection, CAN_PUBLISH_PATH, true);
        if (response != null) {
            return response.getStatus() == 401;
        }
        return false;
    }

    public boolean canPublish(BiServerConnection connection) {
        ClientResponse response = this.httpGet(connection, CAN_PUBLISH_PATH, true);
        if (response != null) {
            this.lastHTTPStatus = response.getStatus();
            return Boolean.parseBoolean((String)response.getEntity(String.class));
        }
        this.lastHTTPStatus = -1;
        return false;
    }

    public boolean canManageDatasources(BiServerConnection connection) {
        ClientResponse response = this.httpGet(connection, CAN_MANAGE_DATASOURCES, true);
        if (response != null) {
            this.lastHTTPStatus = response.getStatus();
            return Boolean.parseBoolean((String)response.getEntity(String.class));
        }
        this.lastHTTPStatus = -1;
        return false;
    }

    public boolean canCreate(BiServerConnection connection) {
        ClientResponse response = this.httpGet(connection, CAN_CREATE_PATH, true);
        if (response != null) {
            return Boolean.parseBoolean((String)response.getEntity(String.class));
        }
        return false;
    }

    public boolean canExecute(BiServerConnection connection) {
        ClientResponse response = this.httpGet(connection, CAN_EXECUTE_PATH, true);
        if (response != null) {
            return Boolean.parseBoolean((String)response.getEntity(String.class));
        }
        return false;
    }

    public boolean isPentahoServer(BiServerConnection connection) {
        if (!this.isBiServerUrlProvided(connection)) {
            return false;
        }
        ClientResponse response = this.httpGet(connection, PENTAHO_WEBCONTEXT_PATH, false);
        if (response != null) {
            String content = (String)response.getEntity(String.class);
            return content != null && content.contains(PENTAHO_WEBCONTEXT_MATCH);
        }
        return false;
    }

    public boolean isBiServerUrlProvided(BiServerConnection connection) {
        return connection != null && StringUtils.isNotBlank((String)connection.getUrl());
    }

    public boolean isUserInfoProvided(BiServerConnection connection) {
        return connection != null && StringUtils.isNotBlank((String)connection.getUserId()) && StringUtils.isNotBlank((String)connection.getPassword());
    }

    public int getLastHTTPStatus() {
        return this.lastHTTPStatus;
    }
}

