/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class KettleObjectMapper {
    private ObjectMapper mapper = new ObjectMapper();
    private SimpleModule transModule;

    public KettleObjectMapper(List<StdSerializer> serializers, List<StdDeserializer> deserializers) {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.enable(SerializationFeature.WRAP_EXCEPTIONS);
        this.transModule = new SimpleModule("PDIModule", new Version(1, 0, 0, null));
        if (!CollectionUtils.isEmpty(serializers)) {
            for (StdSerializer serializer : serializers) {
                this.transModule.addSerializer((JsonSerializer)serializer);
            }
        }
        if (!CollectionUtils.isEmpty(deserializers)) {
            for (StdDeserializer deserializer : deserializers) {
                this.transModule.addDeserializer(deserializer.getValueClass(), (JsonDeserializer)deserializer);
            }
        }
        this.mapper.registerModule((Module)this.transModule);
    }

    public <T> T readValue(String json, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(json, clazz);
    }

    public String writeValueAsString(Object obj) throws JsonProcessingException {
        return this.mapper.writeValueAsString(obj);
    }
}

