/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.step;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransLineageHolderMap;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.step.StepExternalConsumerRowListener;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumerProvider;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.util.MetaverseBeanUtil;

@ExtensionPoint(description="Step external resource listener", extensionPointId="StepBeforeStart", id="stepExternalResource")
public class StepExternalResourceConsumerListener
implements ExtensionPointInterface {
    private IStepExternalResourceConsumerProvider stepConsumerProvider;

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        StepMetaDataCombi stepCombi;
        if (this.stepConsumerProvider == null) {
            this.stepConsumerProvider = (IStepExternalResourceConsumerProvider)MetaverseBeanUtil.getInstance().get("IStepExternalResourceConsumerProvider");
        }
        if ((stepCombi = (StepMetaDataCombi)object) != null) {
            Class<?> metaClass;
            StepMetaInterface meta = stepCombi.meta;
            StepInterface step = stepCombi.step;
            if (meta != null && BaseStepMeta.class.isAssignableFrom(metaClass = meta.getClass()) && this.stepConsumerProvider != null) {
                HashSet metaClassSet = new HashSet(1);
                metaClassSet.add(metaClass);
                List stepConsumers = this.stepConsumerProvider.getExternalResourceConsumers(metaClassSet);
                if (stepConsumers != null) {
                    for (IStepExternalResourceConsumer stepConsumer : stepConsumers) {
                        Collection resources = stepConsumer.getResourcesFromMeta((Object)meta);
                        this.addExternalResources(resources, step);
                        if (!stepConsumer.isDataDriven((Object)meta)) continue;
                        stepCombi.step.addRowListener((RowListener)new StepExternalConsumerRowListener(stepConsumer, step));
                    }
                }
            }
        }
    }

    protected void addExternalResources(Collection<IExternalResourceInfo> resources, StepInterface step) {
        IExecutionProfile executionProfile;
        if (resources != null && (executionProfile = TransLineageHolderMap.getInstance().getLineageHolder(step.getTrans()).getExecutionProfile()) != null) {
            String stepName = step.getStepname();
            Map resourceMap = executionProfile.getExecutionData().getExternalResources();
            LinkedList<IExternalResourceInfo> externalResources = (LinkedList<IExternalResourceInfo>)resourceMap.get(stepName);
            if (externalResources == null) {
                externalResources = new LinkedList<IExternalResourceInfo>();
            }
            externalResources.addAll(resources);
            resourceMap.put(stepName, externalResources);
        }
    }

    public void setStepExternalResourceConsumerProvider(IStepExternalResourceConsumerProvider provider) {
        this.stepConsumerProvider = provider;
    }
}

