/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.step;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransLineageHolderMap;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.IExecutionProfile;

public class StepExternalConsumerRowListener
extends RowAdapter {
    private final IStepExternalResourceConsumer stepExternalResourceConsumer;
    private final StepInterface step;

    public StepExternalConsumerRowListener(IStepExternalResourceConsumer stepExternalResourceConsumer, StepInterface step) {
        this.stepExternalResourceConsumer = stepExternalResourceConsumer;
        this.step = step;
    }

    public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        IExecutionProfile executionProfile;
        Collection resources = this.stepExternalResourceConsumer.getResourcesFromRow((BaseStep)this.step, rowMeta, row);
        if (resources != null && (executionProfile = TransLineageHolderMap.getInstance().getLineageHolder(this.step.getTrans()).getExecutionProfile()) != null) {
            String stepName = this.step.getStepname();
            Map resourceMap = executionProfile.getExecutionData().getExternalResources();
            LinkedList externalResources = (LinkedList)resourceMap.get(stepName);
            if (externalResources == null) {
                externalResources = new LinkedList();
            }
            externalResources.addAll(resources);
            resourceMap.put(stepName, externalResources);
        }
    }
}

