/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.util.ParameterHelper;

public class JVMParameterProvider
implements IParameterProvider {
    public String getStringParameter(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public long getLongParameter(String name, long defaultValue) {
        String pValue = this.getStringParameter(name, null);
        if (pValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(pValue);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }

    public Date getDateParameter(String name, Date defaultValue) {
        return ParameterHelper.parameterToDate(this.getStringParameter(name, null), defaultValue);
    }

    public Object getDecimalParameter(String name, Object defaultValue) {
        String pValue = this.getStringParameter(name, null);
        if (pValue == null) {
            return defaultValue;
        }
        try {
            return new BigDecimal(pValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public Iterator getParameterNames() {
        Properties props = System.getProperties();
        return props.keySet().iterator();
    }

    public String getParameterType(String name) {
        return "string";
    }

    public Object getParameter(String name) {
        return System.getProperty(name);
    }

    public BigDecimal getDecimalParameter(String name, BigDecimal defaultValue) {
        return ParameterHelper.parameterToDecimal(this.getStringParameter(name, ""), defaultValue);
    }

    public Object[] getArrayParameter(String name, Object[] defaultValue) {
        return ParameterHelper.parameterToObjectArray(this.getParameter(name), defaultValue);
    }

    public String[] getStringArrayParameter(String name, String[] defaultValue) {
        return ParameterHelper.parameterToStringArray(this.getParameter(name), defaultValue);
    }
}

