/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.chart.AbstractJFreeChartComponent;
import org.pentaho.platform.uifoundation.chart.BarLineChartDefinition;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class CategoryDatasetChartComponent
extends AbstractJFreeChartComponent {
    private static final long serialVersionUID = -6268840271596447555L;
    protected String seriesName = null;

    public CategoryDatasetChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        super(chartType, definitionPath, width, height, urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public CategoryDatasetChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        super(definitionPath, urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public CategoryDatasetChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    @Override
    public Dataset createChart(Document doc) {
        Node paramName2Node;
        if (this.actionPath != null) {
            this.values = this.getActionData();
        }
        if (this.values == null) {
            return null;
        }
        Node chartAttributes = doc.selectSingleNode("//chart");
        String chType = chartAttributes.selectSingleNode("chart-type").getText();
        CategoryDatasetChartDefinition chartDefinition = null;
        chartDefinition = "BarLineChart".equalsIgnoreCase(chType) ? new BarLineChartDefinition((IPentahoResultSet)this.values, this.byRow, chartAttributes, this.getSession()) : new CategoryDatasetChartDefinition((IPentahoResultSet)this.values, this.byRow, chartAttributes, this.getSession());
        this.setChartType(chartDefinition.getChartType());
        this.setTitle(chartDefinition.getTitle());
        Node urlTemplateNode = chartAttributes.selectSingleNode("url-template");
        if (urlTemplateNode != null) {
            this.setUrlTemplate(urlTemplateNode.getText());
        }
        if ((paramName2Node = chartAttributes.selectSingleNode("series-name")) != null) {
            this.seriesName = paramName2Node.getText();
        }
        if (chartDefinition.getWidth() != -1 && this.width == -1) {
            this.setWidth(chartDefinition.getWidth());
        }
        if (chartDefinition.getHeight() != -1 && this.height == -1) {
            this.setHeight(chartDefinition.getHeight());
        }
        return chartDefinition;
    }

    @Override
    public Document getXmlContent() {
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        String mapName = "chart" + AbstractChartComponent.chartCount++;
        Document chartDefinition = this.jcrHelper.getSolutionDocument(this.definitionPath, RepositoryFilePermission.READ);
        if (chartDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0001_CHART_DEFINIION_MISSING", this.definitionPath);
            errorElement.addElement("message").setText(message);
            this.error(message);
            return result;
        }
        this.dataDefinition = this.createChart(chartDefinition);
        if (this.dataDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0002_CHART_DATA_MISSING", this.actionPath);
            errorElement.addElement("message").setText(message);
            return result;
        }
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        String chartTitle = "";
        try {
            if (this.width == -1) {
                this.width = Integer.parseInt(chartDefinition.selectSingleNode("/chart/width").getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (this.height == -1) {
                this.height = Integer.parseInt(chartDefinition.selectSingleNode("/chart/height").getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (chartDefinition.selectSingleNode("/chart/url-template") != null) {
            this.urlTemplate = chartDefinition.selectSingleNode("/chart/url-template").getText();
        }
        if (chartDefinition.selectSingleNode("/chart/paramName") != null) {
            this.paramName = chartDefinition.selectSingleNode("/chart/paramName").getText();
        }
        Element root = result.addElement("charts");
        DefaultCategoryDataset chartDataDefinition = (DefaultCategoryDataset)this.dataDefinition;
        if (chartDataDefinition.getRowCount() > 0) {
            String[] tempFileInfo = this.createTempFile();
            String fileName = tempFileInfo[0];
            String filePathWithoutExtension = tempFileInfo[1];
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            JFreeChartEngine.saveChart((Dataset)chartDataDefinition, chartTitle, "", filePathWithoutExtension, this.width, this.height, 1, printWriter, info, this);
            this.applyOuterURLTemplateParam();
            this.populateInfo(info);
            Element chartElement = root.addElement("chart");
            chartElement.addElement("mapName").setText(mapName);
            chartElement.addElement("width").setText(Integer.toString(this.width));
            chartElement.addElement("height").setText(Integer.toString(this.height));
            for (int row = 0; row < chartDataDefinition.getRowCount(); ++row) {
                for (int column = 0; column < chartDataDefinition.getColumnCount(); ++column) {
                    Number value = chartDataDefinition.getValue(row, column);
                    Comparable rowKey = chartDataDefinition.getRowKey(row);
                    Comparable columnKey = chartDataDefinition.getColumnKey(column);
                    Element valueElement = chartElement.addElement("value2D");
                    valueElement.addElement("value").setText(value.toString());
                    valueElement.addElement("row-key").setText(rowKey.toString());
                    valueElement.addElement("column-key").setText(columnKey.toString());
                }
            }
            String mapString = ImageMapUtilities.getImageMap((String)mapName, (ChartRenderingInfo)info);
            chartElement.addElement("imageMap").setText(mapString);
            chartElement.addElement("image").setText(fileName);
        }
        return result;
    }

    private void populatePieSectionEntity(PieSectionEntity pieSectionEntity) {
        String value = pieSectionEntity.getSectionKey().toString();
        if (this.paramName == null) {
            pieSectionEntity.setURLText(value);
        } else {
            try {
                String encodedVal = URLEncoder.encode(value, LocaleHelper.getSystemEncoding());
                String drillURL = TemplateUtil.applyTemplate(this.urlTemplate, this.paramName, encodedVal);
                pieSectionEntity.setURLText(drillURL);
            }
            catch (UnsupportedEncodingException ignored) {
                this.getLogger().debug((Object)ignored);
            }
        }
    }

    private void populateCategoryItemEntity(CategoryItemEntity categoryItemEntity, List seriesListArray) {
        if (seriesListArray == null) {
            seriesListArray = new ArrayList(categoryItemEntity.getDataset().getRowKeys());
        }
        String category = categoryItemEntity.getCategory().toString();
        if (this.paramName == null) {
            categoryItemEntity.setURLText(category);
        } else {
            try {
                String encodedVal = URLEncoder.encode(category, LocaleHelper.getSystemEncoding());
                String drillURL = TemplateUtil.applyTemplate(this.urlTemplate, this.paramName, encodedVal);
                int seriesIndex = categoryItemEntity.getSeries();
                encodedVal = Messages.getInstance().getString("CategoryDatasetChartComponent.UNKNOWN_SERIES");
                if (seriesIndex >= 0 && seriesIndex < seriesListArray.size()) {
                    encodedVal = URLEncoder.encode(seriesListArray.get(seriesIndex).toString(), LocaleHelper.getSystemEncoding());
                } else {
                    this.error(Messages.getInstance().getErrorString("CategoryDatasetChartComponent.ERROR_0002_INVALID_SERIES_INDEX", String.valueOf(seriesIndex)));
                }
                drillURL = this.seriesName == null ? TemplateUtil.applyTemplate(drillURL, "SERIES", encodedVal) : TemplateUtil.applyTemplate(drillURL, this.seriesName, encodedVal);
                categoryItemEntity.setURLText(drillURL);
            }
            catch (UnsupportedEncodingException ignored) {
                this.getLogger().debug((Object)ignored);
            }
        }
    }

    private void populateInfo(ChartRenderingInfo info) {
        if (this.urlTemplate == null) {
            return;
        }
        List seriesListArray = null;
        for (ChartEntity entity : info.getEntityCollection()) {
            if (entity instanceof PieSectionEntity) {
                this.populatePieSectionEntity((PieSectionEntity)entity);
                continue;
            }
            if (!(entity instanceof CategoryItemEntity)) continue;
            this.populateCategoryItemEntity((CategoryItemEntity)entity, seriesListArray);
        }
    }

    @Override
    public boolean validate() {
        return true;
    }
}

