/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IParameterManager;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.DateMath;

public class TemplateUtil {
    private static final String PARAMETER_PATTERN = "\\{([^\\}\\{$^]*)\\}";
    private static final String DATE_EXPR_PATTERN = "([\\+\\-\\s]?(\\d)+:[YMWDhms][ES]?[\\s]?)+((\\s)?;.*)?";
    private static final String DATEMATH_EXPR_PATTERN = "DATEMATH\\((\\s*)['\"].*['\"](\\s)*\\)";
    private static final String DATEMATH_VAR_PATTERN = "DATEMATH:.*";
    private static final String DATE_PATTERN = "\\d\\d\\d\\d-\\d\\d-\\d\\d";
    private static final Pattern parameterExpressionPattern = Pattern.compile("\\{([^\\}\\{$^]*)\\}");
    private static final Pattern dateExpressionPattern = Pattern.compile("([\\+\\-\\s]?(\\d)+:[YMWDhms][ES]?[\\s]?)+((\\s)?;.*)?");
    private static final Pattern dateMathExpressionPattern = Pattern.compile("DATEMATH\\((\\s*)['\"].*['\"](\\s)*\\)");
    private static final Pattern dateMathVarPattern = Pattern.compile("DATEMATH:.*");
    private static final Pattern datePattern = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");
    private static final List<String> SystemInputs = new ArrayList<String>();
    private static final Log logger = LogFactory.getLog(TemplateUtil.class);

    public static String getSystemInput(String inputName, IRuntimeContext context) {
        int i = SystemInputs.indexOf(inputName);
        switch (i) {
            case 0: {
                return context.getSession().getName();
            }
            case 1: {
                return PentahoRequestContextHolder.getRequestContext().getContextPath();
            }
            case 2: {
                return PentahoSystem.getApplicationContext().getSolutionPath("");
            }
            case 3: {
                return PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            }
        }
        return null;
    }

    public static String applyTemplate(String template, IRuntimeContext context, IParameterResolver resolver) {
        return TemplateUtil.applyTemplate(template, new InputProperties(context), resolver);
    }

    public static String applyTemplate(String template, IRuntimeContext context) {
        return TemplateUtil.applyTemplate(template, new InputProperties(context), null);
    }

    public static String applyTemplate(String template, IRuntimeContext context, String parameterPatternStr) {
        Pattern pattern = Pattern.compile(parameterPatternStr);
        return TemplateUtil.applyTemplate(template, new InputProperties(context), pattern, null);
    }

    public static String applyTemplate(String template, Properties inputs, IParameterResolver resolver) {
        return TemplateUtil.applyTemplate(template, inputs, parameterExpressionPattern, resolver);
    }

    public static String applyTemplate(String template, Properties inputs, Pattern parameterPattern, IParameterResolver resolver) {
        StringBuffer results = new StringBuffer();
        Matcher parameterMatcher = parameterPattern.matcher(template);
        int copyStart = 0;
        while (parameterMatcher.find()) {
            int start = parameterMatcher.start();
            String parameter = parameterMatcher.group(1);
            String value = null;
            int colonPosition = parameter.indexOf(58);
            boolean hasSpaces = parameter.indexOf(32) != -1;
            boolean isTableTemplate = !hasSpaces && parameter.indexOf(":col:") != -1;
            boolean isComponentResoved = !hasSpaces && colonPosition != -1;
            boolean isNamedParameter = !hasSpaces;
            boolean isDateParamter = hasSpaces;
            if (isTableTemplate) {
                TemplateUtil.applyTableTemplate(template, inputs, parameterPattern, results);
                return results.toString();
            }
            if (isComponentResoved) {
                int newCopyStart;
                if (resolver != null && (newCopyStart = resolver.resolveParameter(template, parameter, parameterMatcher, copyStart, results)) >= 0) {
                    copyStart = newCopyStart;
                    continue;
                }
                StringTokenizer tokenizer = new StringTokenizer(parameter, ":");
                if (tokenizer.countTokens() >= 5) {
                    parameter = tokenizer.nextToken();
                    String keyColumn = tokenizer.nextToken();
                    String keyValue = tokenizer.nextToken();
                    String valueColumn = tokenizer.nextToken();
                    StringBuffer defaultValue = new StringBuffer();
                    defaultValue.append(tokenizer.nextToken());
                    while (tokenizer.hasMoreTokens()) {
                        defaultValue.append(':').append(tokenizer.nextToken());
                    }
                    if (inputs instanceof InputProperties) {
                        value = ((InputProperties)inputs).getProperty(parameter, keyColumn, keyValue, valueColumn, defaultValue.toString());
                    }
                }
            } else if (isNamedParameter && (value = inputs.getProperty(parameter)) == null && logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("TemplateUtil.NOT_FOUND", parameter));
            }
            results.append(template.substring(copyStart, start));
            copyStart = parameterMatcher.end();
            if (isDateParamter || value == null) {
                value = TemplateUtil.matchDateRegex(parameter, inputs);
            }
            if (value == null) {
                results.append(parameterMatcher.group());
                continue;
            }
            results.append(value);
        }
        if (copyStart < template.length()) {
            results.append(template.substring(copyStart));
        }
        return results.toString();
    }

    public static void applyTableTemplate(String template, Properties inputs, Pattern parameterPattern, StringBuffer results) {
        Matcher parameterMatcher = parameterPattern.matcher(template);
        ArrayList<String> partsList = new ArrayList<String>();
        ArrayList<Integer> columnsList = new ArrayList<Integer>();
        int idx = 0;
        int lastEnd = 0;
        IPentahoResultSet data = null;
        while (parameterMatcher.find()) {
            int start = parameterMatcher.start();
            String parameter = parameterMatcher.group(1);
            int pos1 = parameter.indexOf(":col:");
            if (pos1 <= -1) continue;
            String part = template.substring(lastEnd, start);
            logger.debug((Object)("parameter=" + parameter));
            logger.debug((Object)("part=" + part));
            String inputName = parameter.substring(0, pos1);
            String columnNoStr = parameter.substring(pos1 + 5);
            int columnNo = Integer.parseInt(columnNoStr);
            logger.debug((Object)("inputName=" + inputName));
            logger.debug((Object)("columnNoStr=" + columnNoStr));
            logger.debug((Object)("columnNo=" + columnNo));
            Object obj = null;
            if (inputs instanceof InputProperties) {
                obj = ((InputProperties)inputs).getInput(inputName);
            }
            if (obj == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("TemplateUtil.NOT_FOUND", inputName));
                }
            } else if (obj instanceof IPentahoResultSet) {
                data = (IPentahoResultSet)obj;
                if (columnNo < data.getColumnCount()) {
                    columnsList.add(new Integer(columnNo));
                } else {
                    logger.warn((Object)Messages.getInstance().getString("TemplateUtil.INVALID_COLUMN", String.valueOf(columnNo)));
                }
            }
            partsList.add(part);
            lastEnd = parameterMatcher.end();
        }
        logger.debug((Object)("partsList.size()=" + partsList.size()));
        logger.debug((Object)("columnsList.size()=" + columnsList.size()));
        logger.debug((Object)("data=" + data));
        if (partsList.size() > 0) {
            partsList.add(template.substring(lastEnd));
        } else {
            logger.warn((Object)Messages.getInstance().getString("TemplateUtil.NO_TOKEN"));
        }
        if (data != null && partsList.size() == columnsList.size() + 1) {
            String[] parts = new String[partsList.size()];
            partsList.toArray(parts);
            Integer[] cols = new Integer[columnsList.size()];
            columnsList.toArray(cols);
            int rowNo = 0;
            Object[] row = data.getDataRow(rowNo);
            while (row != null) {
                for (idx = 0; idx < cols.length; ++idx) {
                    results.append(parts[idx]);
                    results.append(row[cols[idx]]);
                }
                results.append(parts[parts.length - 1]);
                row = data.getDataRow(++rowNo);
            }
        }
        logger.debug((Object)("results=" + results.toString()));
    }

    public static String applyTemplate(String template, String name, String value) {
        String result = template;
        result = result.replaceAll("\\{" + name + "\\}", value);
        return result;
    }

    public static String applyTemplate(String template, String name, String[] value) {
        if (value == null) {
            return template;
        }
        if (value.length == 1) {
            return TemplateUtil.applyTemplate(template, name, value[0]);
        }
        int pos = template.indexOf("{" + name + "}");
        if (pos == -1) {
            return template;
        }
        int startPos = template.substring(0, pos).lastIndexOf(38);
        if (startPos < 0) {
            startPos = template.substring(0, pos).lastIndexOf(63);
        }
        startPos = startPos < 0 ? 0 : ++startPos;
        int endPos = template.substring(pos + name.length() + 1).indexOf(38);
        if (endPos < 0) {
            endPos = template.substring(pos + name.length() + 1).indexOf(35);
        }
        endPos = endPos < 0 ? template.length() : (endPos += pos + name.length() + 1);
        String result = template.substring(0, startPos);
        String replacePart = template.substring(startPos, endPos);
        result = result + replacePart.replaceAll("\\{" + name + "\\}", value[0]);
        for (int i = 1; i < value.length; ++i) {
            result = result + "&" + replacePart.replaceAll("\\{" + name + "\\}", value[i]);
        }
        result = result + template.substring(endPos);
        return result;
    }

    public static String matchDateRegex(String parameter) {
        return TemplateUtil.matchDateRegex(parameter, null);
    }

    public static String matchDateRegex(String parameter, Properties inputs) {
        int pos;
        Matcher dateMatcher = dateExpressionPattern.matcher(parameter);
        String value = null;
        if (dateMatcher.matches()) {
            value = parameter.indexOf(59) != -1 ? DateMath.calculateDateString(null, parameter) : DateMath.calculateDateString(null, parameter + ";yyyy-MM-dd");
        }
        if (value == null && (dateMatcher = dateMathExpressionPattern.matcher(parameter)).matches()) {
            pos = parameter.indexOf(39);
            if (pos == -1) {
                pos = parameter.indexOf(34);
            }
            if (pos != -1) {
                if ((pos = (parameter = parameter.substring(pos + 1)).lastIndexOf(39)) == -1) {
                    pos = parameter.lastIndexOf(34);
                }
                if (pos != -1) {
                    parameter = parameter.substring(0, pos);
                    value = TemplateUtil.matchDateRegex(parameter, inputs);
                }
            }
        }
        if (value == null && (dateMatcher = dateMathVarPattern.matcher(parameter)).matches()) {
            pos = parameter.indexOf(58);
            parameter = parameter.substring(pos + 1);
            if ((parameter = inputs.getProperty(parameter)) != null) {
                value = TemplateUtil.matchDateRegex(parameter, inputs);
            }
        }
        if (value == null && (dateMatcher = datePattern.matcher(parameter)).matches()) {
            value = parameter;
        }
        return value;
    }

    public static Properties parametersToProperties(IParameterProvider parameterProvider) {
        Properties properties = new Properties();
        Iterator names = parameterProvider.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = parameterProvider.getStringParameter(name, null);
            if (value == null) continue;
            properties.put(name, value);
        }
        return properties;
    }

    static {
        SystemInputs.add("$user");
        SystemInputs.add("$url");
        SystemInputs.add("$solution");
    }

    private static class InputProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private IRuntimeContext context;
        private Set<String> inputs;
        private static final Log inputPropertiesLogger = LogFactory.getLog(InputProperties.class);

        InputProperties(IRuntimeContext context) {
            this.context = context;
            this.inputs = new HashSet<String>();
            this.inputs.addAll(context.getInputNames());
            this.inputs.addAll(context.getParameterManager().getCurrentInputNames());
            this.inputs.add("$user");
            this.inputs.add("$url");
            this.inputs.add("$solution");
        }

        @Override
        public int size() {
            if (this.inputs == null) {
                return 0;
            }
            return this.inputs.size();
        }

        public String getProperty(String parameter, String keyColumn, String keyValue, String valueColumn, String defaultValue) {
            if (!this.context.getInputNames().contains(parameter)) {
                return "{" + parameter + ":" + keyColumn + ":" + keyValue + ":" + valueColumn + ":" + defaultValue + "}";
            }
            Object valueObj = this.context.getInputParameterValue(parameter);
            if (valueObj instanceof IPentahoResultSet) {
                IPentahoResultSet data = (IPentahoResultSet)valueObj;
                int keyColumnNo = data.getMetaData().getColumnIndex(keyColumn);
                if (keyValue.indexOf(95) > 0) {
                    keyValue = keyValue.replace('_', ' ');
                }
                int valueColumnNo = data.getMetaData().getColumnIndex(valueColumn);
                if (keyColumnNo != -1 && valueColumnNo != -1) {
                    for (int row = 0; row < data.getRowCount(); ++row) {
                        Object thisKey = data.getValueAt(row, keyColumnNo);
                        if (thisKey == null || !keyValue.equals(thisKey.toString())) continue;
                        return data.getValueAt(row, valueColumnNo).toString();
                    }
                }
            }
            return defaultValue;
        }

        public Object getInput(String name) {
            Object value = null;
            if (this.inputs == null) {
                return null;
            }
            if (this.inputs.contains(name)) {
                value = TemplateUtil.getSystemInput(name, this.context);
                if (value != null) {
                    return value;
                }
                value = this.context.getInputParameterValue(name);
            }
            return value;
        }

        @Override
        public String getProperty(String name) {
            String value = null;
            if (this.inputs == null) {
                return null;
            }
            if (this.inputs.contains(name)) {
                Object valueObj;
                value = TemplateUtil.getSystemInput(name, this.context);
                if (value != null) {
                    return value;
                }
                IParameterManager paramMgr = this.context.getParameterManager();
                Map allParams = paramMgr.getAllParameters();
                if (allParams.containsKey(name)) {
                    IActionParameter param = (IActionParameter)allParams.get(name);
                    valueObj = param.getValue();
                } else {
                    valueObj = this.context.getInputParameterValue(name);
                }
                if (valueObj instanceof String) {
                    value = (String)valueObj;
                } else if (valueObj instanceof Object[]) {
                    Object[] values = (Object[])valueObj;
                    StringBuffer valuesBuffer = new StringBuffer();
                    for (int i = 0; i < values.length; ++i) {
                        if (i == 0) {
                            valuesBuffer.append("'").append(values[i].toString()).append("'");
                            continue;
                        }
                        valuesBuffer.append(",'").append(values[i].toString()).append("'");
                    }
                    String valueStr = valuesBuffer.toString();
                    value = valueStr.substring(1, valueStr.length() - 1);
                } else if (valueObj instanceof IPentahoResultSet) {
                    IPentahoResultSet rs = (IPentahoResultSet)valueObj;
                    IPentahoMetaData md = rs.getMetaData();
                    int columnIdx = -1;
                    columnIdx = md.getColumnCount() == 1 ? 0 : md.getColumnIndex(new String[]{name});
                    if (columnIdx < 0) {
                        inputPropertiesLogger.error((Object)Messages.getInstance().getErrorString("Template.ERROR_0005_COULD_NOT_DETERMINE_COLUMN"));
                        return null;
                    }
                    int rowCount = rs.getRowCount();
                    Object valueCell = null;
                    StringBuffer valuesBuffer = new StringBuffer();
                    for (int i = 0; i < rowCount; ++i) {
                        valueCell = rs.getValueAt(i, columnIdx);
                        if (i == 0) {
                            valuesBuffer.append("'").append(valueCell.toString()).append("'");
                            continue;
                        }
                        valuesBuffer.append(",'").append(valueCell.toString()).append("'");
                    }
                    String valueStr = valuesBuffer.toString();
                    value = valueStr.substring(1, valueStr.length() - 1);
                } else if (valueObj != null) {
                    value = valueObj.toString();
                }
            } else {
                value = super.getProperty(name);
            }
            if (value == null) {
                value = TemplateUtil.matchDateRegex(name, null);
            } else {
                String tempValue = TemplateUtil.matchDateRegex(value, null);
                if (tempValue != null) {
                    value = tempValue;
                }
            }
            return value;
        }
    }
}

