/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PentahoBeanScopeValidatorPostProcessor
implements BeanFactoryPostProcessor {
    private static Log logger = LogFactory.getLog(PentahoBeanScopeValidatorPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory != null && beanFactory.getBeanDefinitionCount() > 0) {
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                this.validateBeanScope(beanName, beanFactory.getBeanDefinition(beanName));
            }
        }
    }

    protected void validateBeanScope(String beanName, BeanDefinition bd) {
        if (bd != null && StringUtils.isEmpty((String)bd.getScope())) {
            logger.info((Object)("Setting '" + beanName + "' with 'singleton' scope"));
            bd.setScope("singleton");
        }
    }
}

