/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.system;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IDatabaseDialectProvider;
import org.pentaho.database.IDriverLocator;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.ClassUtil;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PentahoSystemDatabaseDialectProvider
implements IDatabaseDialectProvider {
    private final Function<Class<IDatabaseDialect>, List<IDatabaseDialect>> dialectGetter;

    public PentahoSystemDatabaseDialectProvider() {
        this.dialectGetter = PentahoSystem::getAll;
    }

    public PentahoSystemDatabaseDialectProvider(Function<Class<IDatabaseDialect>, List<IDatabaseDialect>> dialectGetter) {
        this.dialectGetter = dialectGetter;
    }

    private Stream<IDatabaseDialect> getDialectStream() {
        return this.dialectGetter.apply(IDatabaseDialect.class).stream();
    }

    private Stream<IDatabaseDialect> filterUsableDialects(Stream<IDatabaseDialect> stream, boolean usableOnly) {
        if (usableOnly) {
            return stream.filter(dialect -> {
                if (dialect instanceof IDriverLocator) {
                    return ((IDriverLocator)dialect).isUsable();
                }
                return ClassUtil.canLoadClass((String)dialect.getNativeDriver());
            });
        }
        return stream;
    }

    public Collection<IDatabaseDialect> getDialects(boolean usableOnly) {
        return this.filterUsableDialects(this.getDialectStream(), usableOnly).collect(Collectors.toList());
    }

    public IDatabaseDialect getDialect(boolean usableOnly, IDatabaseType databaseType) {
        if (databaseType == null) {
            return null;
        }
        Stream<IDatabaseDialect> dialects = this.getDialectStream().filter(dialect -> dialect.getDatabaseType().equals(databaseType));
        return this.filterUsableDialects(dialects, usableOnly).findFirst().orElse(null);
    }
}

