/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.job;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

class Java {
    Java() {
    }

    public static class Response
    extends BasicResponse {
        public Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Filter[])new Filter[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        String jar;
        String app;
        String input;
        String output;
        List<NameValuePair> params = new ArrayList<NameValuePair>();

        public Request(Hadoop session) {
            super(session);
        }

        public Request jar(String jar) {
            this.jar = jar;
            return this;
        }

        public Request app(String app) {
            this.app = app;
            return this;
        }

        public Request input(String dir) {
            this.input = dir;
            return this;
        }

        public Request output(String dir) {
            this.output = dir;
            return this;
        }

        public Request arg(String value) {
            this.addParam(this.params, "arg", value);
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = Request.this.uri(new String[]{"/templeton/v1", "/mapreduce/jar"});
                    Request.this.params.add((NameValuePair)new BasicNameValuePair("jar", Request.this.jar));
                    Request.this.params.add((NameValuePair)new BasicNameValuePair("class", Request.this.app));
                    Request.this.params.add((NameValuePair)new BasicNameValuePair("arg", Request.this.input));
                    Request.this.params.add((NameValuePair)new BasicNameValuePair("arg", Request.this.output));
                    UrlEncodedFormEntity form = new UrlEncodedFormEntity(Request.this.params);
                    HttpPost request = new HttpPost(uri.build());
                    request.setEntity((HttpEntity)form);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)request));
                }
            };
        }
    }
}

