/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterStringColRegExpStringScalar
extends AbstractFilterStringColLikeStringScalar {
    private static final long serialVersionUID = 1L;
    private static final String LITERAL_CHAR = "[^\\[\\]\\\\(){}*?+|$^.]";
    private static final String LITERAL_CHAR_GROUP = "([^\\[\\]\\\\(){}*?+|$^.]+)";
    private static transient List<AbstractFilterStringColLikeStringScalar.CheckerFactory> checkerFactories = Arrays.asList(new ComplexCheckerFactory());

    public FilterStringColRegExpStringScalar() {
    }

    public FilterStringColRegExpStringScalar(int colNum, byte[] regExpPattern) throws HiveException {
        super(colNum, null);
        try {
            super.setPattern(new String(regExpPattern, "UTF-8"));
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
    }

    @Override
    protected List<AbstractFilterStringColLikeStringScalar.CheckerFactory> getCheckerFactories() {
        return checkerFactories;
    }

    private static class ComplexCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private ComplexCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            return new AbstractFilterStringColLikeStringScalar.ComplexChecker(pattern);
        }
    }

    private static class NoneCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern NONE_PATTERN = Pattern.compile("([^\\[\\]\\\\(){}*?+|$^.]+)");

        private NoneCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = NONE_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.NoneChecker(matcher.group(1));
            }
            return null;
        }
    }

    private static class PhoneNumberCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private PhoneNumberCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            if (pattern.matches("(\\\\d|\\\\\\(|\\\\\\)|-| )+")) {
                return new PhoneNumberChecker(pattern.replaceAll("\\\\d", "d").replaceAll("\\\\\\(", "(").replaceAll("\\\\\\)", ")"));
            }
            return null;
        }
    }

    private static class PhoneNumberChecker
    implements AbstractFilterStringColLikeStringScalar.Checker {
        byte[] byteSub;

        PhoneNumberChecker(String pattern) {
            this.byteSub = pattern.getBytes();
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            block4: for (int i = 0; i < len; ++i) {
                byte c = byteS[start + i];
                byte p = this.byteSub[i];
                switch (p) {
                    case 100: {
                        if (48 <= c && c <= 57) continue block4;
                        return false;
                    }
                    case 32: 
                    case 40: 
                    case 41: 
                    case 45: {
                        if (c == p) continue block4;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class MiddleCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern MIDDLE_PATTERN = Pattern.compile("\\.\\*([^\\[\\]\\\\(){}*?+|$^.]+)\\.\\*");

        private MiddleCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = MIDDLE_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.MiddleChecker(matcher.group(1));
            }
            return null;
        }
    }

    private static class EndCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern END_PATTERN = Pattern.compile("\\.\\*([^\\[\\]\\\\(){}*?+|$^.]+)");

        private EndCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = END_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.EndChecker(matcher.group(1));
            }
            return null;
        }
    }

    private static class BeginCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern BEGIN_PATTERN = Pattern.compile("([^\\[\\]\\\\(){}*?+|$^.]+)\\.\\*");

        private BeginCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = BEGIN_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.BeginChecker(matcher.group(1));
            }
            return null;
        }
    }
}

