/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OSGIResourceNamingConvention {
    public static final String RESOURCES_ROOT_FOLDER = "i18n";
    public static final String RESOURCES_DEFAULT_EXTENSION = ".properties";
    public static final Pattern RESOURCE_NAME_PATTERN = Pattern.compile("(.*/[^_]+)(.*).properties(\\.\\d+)?");

    public static Matcher getResourceNameMatcher(String path) {
        Matcher matcher = RESOURCE_NAME_PATTERN.matcher(path);
        boolean matches = matcher.matches();
        if (matches) {
            return matcher;
        }
        throw new IllegalArgumentException("Path must be of the form prefix/filename[_internationalization].properties[.priority]");
    }

    public static int getPropertyPriority(String propertyName) {
        int priority = 0;
        Matcher matcher = OSGIResourceNamingConvention.getResourceNameMatcher(propertyName);
        String groop = matcher.group(matcher.groupCount());
        if (groop != null) {
            priority = Integer.parseInt(groop.substring(1));
        }
        return priority;
    }

    public static List<String> getCandidateNames(String name, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        String current = name;
        result.add(current);
        String language = locale.getLanguage();
        if (language.length() > 0) {
            current = current + "_" + language;
            result.add(current);
            String country = locale.getCountry();
            if (country.length() > 0) {
                current = current + "_" + country;
                result.add(current);
            }
        }
        Collections.reverse(result);
        return result;
    }
}

