/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.action.hadoop.OozieJobInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.StartTransitionXCommand;
import org.apache.oozie.command.bundle.BundleCoordSubmitXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class BundleStartXCommand
extends StartTransitionXCommand {
    private final String jobId;
    private BundleJobBean bundleJob;

    public BundleStartXCommand(String jobId) {
        super("bundle_start", "bundle_start", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    public BundleStartXCommand(String jobId, boolean dryrun) {
        super("bundle_start", "bundle_start", 1, dryrun);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.bundleJob.getStatus() != Job.Status.PREP) {
            String msg = "Bundle " + this.bundleJob.getId() + " is not in PREP status. It is in : " + this.bundleJob.getStatus();
            this.LOG.info(msg);
            throw new PreconditionException(ErrorCode.E1100, msg);
        }
    }

    @Override
    public void loadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, this.jobId);
            LogUtils.setLogInfo(this.bundleJob);
            super.setJob((Job)this.bundleJob);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public void StartChildren() throws CommandException {
        this.LOG.debug("Started coord jobs for the bundle=[{0}]", this.jobId);
        this.insertBundleActions();
        this.startCoordJobs();
        this.LOG.debug("Ended coord jobs for the bundle=[{0}]", this.jobId);
    }

    @Override
    public void notifyParent() {
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    private void insertBundleActions() throws CommandException {
        if (this.bundleJob != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            try {
                Element bAppXml = XmlUtils.parseXml(this.bundleJob.getJobXml());
                List coordElems = bAppXml.getChildren("coordinator", bAppXml.getNamespace());
                for (Element elem : coordElems) {
                    Attribute name = elem.getAttribute("name");
                    Attribute critical = elem.getAttribute("critical");
                    if (name != null) {
                        if (map.containsKey(name.getValue())) {
                            throw new CommandException(ErrorCode.E1304, name);
                        }
                        Configuration coordConf = this.mergeConfig(elem);
                        if (!this.isEnabled(elem, coordConf)) continue;
                        boolean isCritical = false;
                        if (critical != null && Boolean.parseBoolean(critical.getValue())) {
                            isCritical = true;
                        }
                        map.put(name.getValue(), isCritical);
                        continue;
                    }
                    throw new CommandException(ErrorCode.E1305, new Object[0]);
                }
            }
            catch (JDOMException jex) {
                throw new CommandException(ErrorCode.E1301, new Object[]{jex.getMessage(), jex});
            }
            if (map.isEmpty()) {
                this.bundleJob.setStatus(Job.Status.FAILED);
                this.bundleJob.resetPending();
                try {
                    BundleJobQueryExecutor.getInstance().executeUpdate(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, this.bundleJob);
                }
                catch (JPAExecutorException jex) {
                    throw new CommandException(jex);
                }
                this.LOG.debug("No coord jobs for the bundle=[{0}], failed it!!", this.jobId);
                throw new CommandException(ErrorCode.E1318, this.jobId);
            }
            for (Map.Entry coordName : map.entrySet()) {
                BundleActionBean action = this.createBundleAction(this.jobId, (String)coordName.getKey(), (Boolean)coordName.getValue());
                this.insertList.add(action);
            }
        } else {
            throw new CommandException(ErrorCode.E0604, this.jobId);
        }
    }

    private BundleActionBean createBundleAction(String jobId, String coordName, boolean isCritical) {
        BundleActionBean action = new BundleActionBean();
        action.setBundleActionId(jobId + "_" + coordName);
        action.setBundleId(jobId);
        action.setCoordName(coordName);
        action.setStatus(Job.Status.PREP);
        action.setLastModifiedTime(new Date());
        if (isCritical) {
            action.setCritical();
        } else {
            action.resetCritical();
        }
        return action;
    }

    private void startCoordJobs() throws CommandException {
        if (this.bundleJob != null) {
            try {
                Element bAppXml = XmlUtils.parseXml(this.bundleJob.getJobXml());
                List coordElems = bAppXml.getChildren("coordinator", bAppXml.getNamespace());
                for (Element coordElem : coordElems) {
                    Attribute name = coordElem.getAttribute("name");
                    Configuration coordConf = this.mergeConfig(coordElem);
                    coordConf.set("oozie.bundle.id", this.jobId);
                    if (OozieJobInfo.isJobInfoEnabled()) {
                        coordConf.set("bundle.name", this.bundleJob.getAppName());
                    }
                    if (!this.isEnabled(coordElem, coordConf)) continue;
                    String coordName = name.getValue();
                    try {
                        coordName = ELUtils.resolveAppName(coordName, coordConf);
                    }
                    catch (Exception e) {
                        throw new CommandException(ErrorCode.E1321, e.getMessage(), e);
                    }
                    this.queue(new BundleCoordSubmitXCommand(coordConf, this.bundleJob.getId(), name.getValue()));
                }
                this.updateBundleAction();
            }
            catch (JDOMException jex) {
                throw new CommandException(ErrorCode.E1301, new Object[]{jex.getMessage(), jex});
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        throw new CommandException(ErrorCode.E0604, this.jobId);
    }

    private void updateBundleAction() throws JPAExecutorException {
        for (JsonBean bAction : this.insertList) {
            BundleActionBean action = (BundleActionBean)bAction;
            action.incrementAndGetPending();
            action.setLastModifiedTime(new Date());
        }
    }

    private Configuration mergeConfig(Element coordElem) throws CommandException {
        String jobConf = this.bundleJob.getConf();
        XConfiguration runConf = null;
        try {
            runConf = new XConfiguration(new StringReader(jobConf));
        }
        catch (IOException e1) {
            this.LOG.warn("Configuration parse error in:" + jobConf);
            throw new CommandException(ErrorCode.E1306, e1.getMessage(), e1);
        }
        Element localConfigElement = coordElem.getChild("configuration", coordElem.getNamespace());
        if (localConfigElement != null) {
            XConfiguration localConf;
            String strConfig = XmlUtils.prettyPrint(localConfigElement).toString();
            try {
                localConf = new XConfiguration(new StringReader(strConfig));
            }
            catch (IOException e1) {
                this.LOG.warn("Configuration parse error in:" + strConfig);
                throw new CommandException(ErrorCode.E1307, e1.getMessage(), e1);
            }
            XConfiguration.copy(localConf, runConf);
        }
        String appPath = coordElem.getChild("app-path", coordElem.getNamespace()).getValue();
        runConf.set("oozie.coord.application.path", appPath);
        try {
            JobUtils.normalizeAppPath(runConf.get("user.name"), runConf.get("group.name"), runConf);
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E1001, runConf.get("oozie.coord.application.path"));
        }
        return runConf;
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void updateJob() throws CommandException {
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleJobQueryExecutor.BundleJobQuery>(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, this.bundleJob));
    }

    private boolean isEnabled(Element coordElem, Configuration coordConf) throws CommandException {
        Attribute enabled = coordElem.getAttribute("enabled");
        if (enabled == null) {
            return true;
        }
        String isEnabled = enabled.getValue();
        try {
            isEnabled = ELUtils.resolveAppName(isEnabled, coordConf);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1321, e.getMessage(), e);
        }
        return Boolean.parseBoolean(isEnabled);
    }
}

