/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle.parameter;

import java.beans.PropertyEditor;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.libraries.designtime.swing.table.GroupingHeader;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTableModel;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterEntity;
import org.pentaho.reporting.ui.datasources.kettle.parameter.Messages;

public class FormulaParameterTableModel
extends AbstractTableModel
implements PropertyTableModel {
    private static final FormulaParameterEntity[] EMPTY_ELEMENTS = new FormulaParameterEntity[0];
    private FormulaParameterEntity[] elements = EMPTY_ELEMENTS;

    @Override
    public int getRowCount() {
        return this.elements.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getInstance().getString("FormulaParameterTableModel.Name");
        }
        return Messages.getInstance().getString("FormulaParameterTableModel.Value");
    }

    protected void updateData(FormulaParameterEntity[] elements) {
        this.elements = (FormulaParameterEntity[])elements.clone();
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FormulaParameterEntity metaData = this.elements[rowIndex];
        if (metaData == null) {
            return this.elements[rowIndex];
        }
        switch (columnIndex) {
            case 0: {
                return metaData;
            }
            case 1: {
                return metaData.getValue();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        FormulaParameterEntity metaData = this.elements[rowIndex];
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return metaData.getType() == FormulaParameterEntity.Type.PARAMETER;
            }
            case 1: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FormulaParameterEntity metaData = this.elements[rowIndex];
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                if (aValue instanceof FormulaParameterEntity) {
                    FormulaParameterEntity name = (FormulaParameterEntity)aValue;
                    metaData.setName(name.getName());
                    this.fireTableDataChanged();
                }
                return;
            }
            case 1: {
                if (aValue == null) {
                    metaData.setValue(null);
                } else {
                    metaData.setValue(String.valueOf(aValue));
                }
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Class getClassForCell(int row, int column) {
        FormulaParameterEntity metaData = this.elements[row];
        if (metaData == null) {
            return GroupingHeader.class;
        }
        if (column == 0) {
            return FormulaParameterEntity.class;
        }
        return String.class;
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        return null;
    }

    public void setData(FormulaParameterEntity[] parameter) {
        this.updateData(parameter);
    }

    public FormulaParameterEntity[] getData() {
        return (FormulaParameterEntity[])this.elements.clone();
    }

    public FormulaParameterEntity.Type getParameterType(int row) {
        FormulaParameterEntity downParameter = this.elements[row];
        if (downParameter != null) {
            return downParameter.getType();
        }
        return null;
    }
}

