/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle.parameter;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.HashSet;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterEditor;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterEntity;

public class FormulaParameterDialog
extends CommonDialog {
    private FormulaParameterEditor editor;
    private DesignTimeContext context;

    public FormulaParameterDialog(Dialog owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.context = context;
        this.init();
    }

    protected String getDialogId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void init() {
        this.editor = new FormulaParameterEditor();
        this.editor.setFormulaContext(this.context.getDataFactoryContext().getFormulaContext());
        super.init();
    }

    public EditResult performEdit(FormulaArgument[] argumentNames, FormulaParameter[] parameterMappings, FieldDefinition[] reportFields, KettleParameterInfo[] transformationParameters) {
        this.editor.setFields(reportFields);
        this.editor.setFormulaParameter(this.build(argumentNames, parameterMappings, transformationParameters));
        if (!this.performEdit()) {
            return null;
        }
        return new EditResult(this.extractArguments(), this.extractParameter());
    }

    private FormulaParameter[] extractParameter() {
        FormulaParameterEntity[] formulaParameter = this.editor.getFormulaParameter();
        ArrayList<FormulaParameter> l = new ArrayList<FormulaParameter>();
        for (FormulaParameterEntity entity : formulaParameter) {
            String value;
            if (entity.getType() != FormulaParameterEntity.Type.PARAMETER || StringUtils.isEmpty((String)(value = entity.getValue()), (boolean)true)) continue;
            l.add(new FormulaParameter(entity.getName(), value));
        }
        return l.toArray(new FormulaParameter[l.size()]);
    }

    private FormulaArgument[] extractArguments() {
        FormulaParameterEntity[] formulaParameter = this.editor.getFormulaParameter();
        ArrayList<FormulaArgument> l = new ArrayList<FormulaArgument>();
        for (FormulaParameterEntity entity : formulaParameter) {
            if (entity.getType() != FormulaParameterEntity.Type.ARGUMENT) continue;
            String value = entity.getValue();
            l.add(new FormulaArgument(value));
        }
        return l.toArray(new FormulaArgument[l.size()]);
    }

    private FormulaParameterEntity[] build(FormulaArgument[] argumentNames, FormulaParameter[] parameterMappings, KettleParameterInfo[] transformationParameters) {
        ArrayList<FormulaParameterEntity> l = new ArrayList<FormulaParameterEntity>();
        for (FormulaArgument argumentName : argumentNames) {
            FormulaParameterEntity formulaParameterEntity = new FormulaParameterEntity(FormulaParameterEntity.Type.ARGUMENT, "Argument " + (l.size() + 1), argumentName.getFormula());
            l.add(formulaParameterEntity);
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (FormulaParameter formulaParameter : parameterMappings) {
            l.add(new FormulaParameterEntity(FormulaParameterEntity.Type.PARAMETER, formulaParameter.getName(), formulaParameter.getFormula()));
            usedNames.add(formulaParameter.getName());
        }
        for (KettleParameterInfo kettleParameterInfo : transformationParameters) {
            if (usedNames.contains(kettleParameterInfo.getName())) continue;
            l.add(new FormulaParameterEntity(FormulaParameterEntity.Type.PARAMETER, kettleParameterInfo.getName(), null));
        }
        return l.toArray(new FormulaParameterEntity[l.size()]);
    }

    protected Component createContentPane() {
        return this.editor;
    }

    public static class EditResult {
        private FormulaArgument[] argumentNames;
        private FormulaParameter[] parameterMappings;

        public EditResult(FormulaArgument[] argumentNames, FormulaParameter[] parameterMappings) {
            ArgumentNullException.validate((String)"argumentNames", (Object)argumentNames);
            ArgumentNullException.validate((String)"parameterMappings", (Object)parameterMappings);
            this.argumentNames = argumentNames;
            this.parameterMappings = parameterMappings;
        }

        public FormulaArgument[] getArgumentNames() {
            return (FormulaArgument[])this.argumentNames.clone();
        }

        public FormulaParameter[] getParameterMappings() {
            return (FormulaParameter[])this.parameterMappings.clone();
        }
    }
}

