/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseObjectFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class BaseMetaverseBuilder
extends MetaverseObjectFactory
implements IMetaverseBuilder {
    private static final String ENTITY_PREFIX = "entity_";
    private static final String ENTITY_NODE_ID = "entity";
    private static final String SEPARATOR = "~";
    private Graph graph;
    private IMetaverseObjectFactory metaverseObjectFactory = this;

    public BaseMetaverseBuilder(Graph graph) {
        this.graph = graph;
        this.registerStaticNodes();
    }

    protected void registerStaticNodes() {
        DictionaryHelper.registerEntityTypes();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public IMetaverseBuilder addLink(IMetaverseLink link) {
        Vertex fromVertex = this.getVertexForNode(link.getFromNode());
        Vertex toVertex = this.getVertexForNode(link.getToNode());
        if (fromVertex == null) {
            fromVertex = this.addVertex(link.getFromNode());
            fromVertex.setProperty("virtual", (Object)true);
        }
        this.copyNodePropertiesToVertex(link.getFromNode(), fromVertex);
        if (toVertex == null) {
            toVertex = this.addVertex(link.getToNode());
            toVertex.setProperty("virtual", (Object)true);
        }
        this.copyNodePropertiesToVertex(link.getToNode(), toVertex);
        Edge edge = this.addEdge(fromVertex, link.getLabel(), toVertex);
        this.copyLinkPropertiesToEdge(link, edge);
        return this;
    }

    public static String getEdgeId(Vertex fromVertex, String label, Vertex toVertex) {
        return fromVertex.getId() + SEPARATOR + label + SEPARATOR + toVertex.getId();
    }

    @Override
    public IMetaverseBuilder addNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v == null) {
            v = this.addVertex(node);
        }
        v.setProperty("virtual", (Object)false);
        this.copyNodePropertiesToVertex(node, v);
        return this;
    }

    private Vertex addVertex(IMetaverseNode node) {
        Vertex v = this.graph.addVertex((Object)node.getStringID());
        if (DictionaryHelper.isEntityType(node.getType())) {
            this.addEdge(this.addEntityType(node.getType()), DictionaryHelper.getNonEntityToEntityLinkType(), v, DictionaryHelper.addNonEntityToEntityLinkTypeLabel());
        }
        return v;
    }

    @Deprecated
    protected Vertex addEntityType(String entityName, String parent) {
        return this.addEntityType(entityName);
    }

    protected Vertex addEntityType(String entityName) {
        if (this.graph == null) {
            return null;
        }
        Vertex entityType = this.graph.getVertex((Object)(ENTITY_PREFIX + entityName));
        if (entityType == null) {
            entityType = this.graph.addVertex((Object)(ENTITY_PREFIX + entityName));
            entityType.setProperty("type", (Object)"Entity");
            entityType.setProperty("name", (Object)entityName);
            if (entityName.equals("Transformation") || entityName.equals("Job")) {
                entityType.setProperty("description", (Object)"Pentaho Data Integration");
            }
            for (String entityLinkType : DictionaryHelper.getEntityLinkTypes()) {
                String parentEntityNode = DictionaryHelper.getParentEntityNodeType(entityLinkType, entityName);
                if (parentEntityNode != null) {
                    this.addEdge(this.addEntityType(parentEntityNode), entityLinkType, entityType);
                    continue;
                }
                if (!DictionaryHelper.linksToRoot(entityLinkType, entityName)) continue;
                this.addEdge(this.createRootEntity(), entityLinkType, entityType);
            }
        }
        return entityType;
    }

    public Vertex createRootEntity() {
        Vertex rootEntity = this.graph.getVertex((Object)ENTITY_NODE_ID);
        if (rootEntity == null) {
            rootEntity = this.graph.addVertex((Object)ENTITY_NODE_ID);
            rootEntity.setProperty("type", (Object)"Root_Entity");
            rootEntity.setProperty("name", (Object)"METAVERSE");
            rootEntity.setProperty("division", (Object)"Engineering");
            rootEntity.setProperty("project", (Object)"Pentaho Data Lineage");
            rootEntity.setProperty("description", (Object)"Data lineage is tracing the path that data has traveled upstream from its destination, through Pentaho systems and artifacts as well as external systems and artifacts.");
        }
        return rootEntity;
    }

    private void copyNodePropertiesToVertex(IMetaverseNode node, Vertex v) {
        Boolean nodeIsVirtual = (Boolean)node.getProperty("virtual");
        nodeIsVirtual = nodeIsVirtual == null ? true : nodeIsVirtual;
        Boolean vertexIsVirtual = (Boolean)v.getProperty("virtual");
        vertexIsVirtual = vertexIsVirtual == null ? false : vertexIsVirtual;
        String vertexLogicalId = (String)v.getProperty("logicalId");
        boolean skipLogicalId = false;
        if (vertexLogicalId != null && nodeIsVirtual.booleanValue() && !vertexIsVirtual.booleanValue()) {
            skipLogicalId = true;
        }
        for (String propertyKey : node.getPropertyKeys()) {
            Object value;
            if (propertyKey.equals("id") || propertyKey.equals("virtual") || skipLogicalId && propertyKey.equals("logicalId") || (value = node.getProperty(propertyKey)) == null) continue;
            v.setProperty(propertyKey, value);
        }
        node.setDirty(false);
    }

    public void copyLinkPropertiesToEdge(IMetaverseLink link, Edge e) {
        if (link != null && link.getPropertyKeys() != null && e != null) {
            for (String propertyKey : link.getPropertyKeys()) {
                Object value;
                if ("label".equals(propertyKey) || (value = link.getProperty(propertyKey)) == null) continue;
                e.setProperty(propertyKey, value);
            }
        }
    }

    public Vertex getVertexForNode(IMetaverseNode node) {
        if (node != null) {
            Iterable logicalMatches;
            Iterator iterator;
            String logicalId = node.getLogicalId();
            Vertex vertex = this.graph.getVertex((Object)node.getStringID());
            if (vertex == null && !logicalId.equals(node.getStringID()) && (iterator = (logicalMatches = this.graph.getVertices("logicalId", (Object)logicalId)).iterator()).hasNext()) {
                Vertex match;
                vertex = match = (Vertex)iterator.next();
            }
            return vertex;
        }
        return null;
    }

    @Override
    public IMetaverseBuilder deleteLink(IMetaverseLink link) {
        this.deleteLink(link, true);
        return this;
    }

    private boolean deleteLink(IMetaverseLink link, boolean removeVirtualNodes) {
        if (link == null) {
            return false;
        }
        Vertex fromVertex = this.getVertexForNode(link.getFromNode());
        Vertex toVertex = null;
        Edge deleteMe = null;
        boolean result = false;
        if (fromVertex != null) {
            for (Edge edge : fromVertex.getEdges(Direction.OUT, new String[]{link.getLabel()})) {
                toVertex = edge.getVertex(Direction.IN);
                if (!toVertex.getId().equals(link.getToNode().getStringID())) continue;
                deleteMe = edge;
                break;
            }
            if (deleteMe != null) {
                this.graph.removeEdge(deleteMe);
                result = true;
            }
            if (removeVirtualNodes) {
                Vertex[] fromAndTo;
                for (Vertex v : fromAndTo = new Vertex[]{fromVertex, toVertex}) {
                    if (!this.isVirtual(v)) continue;
                    this.graph.removeVertex(v);
                }
            }
        }
        return result;
    }

    @Override
    public IMetaverseBuilder deleteNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v != null) {
            this.graph.removeVertex(v);
        }
        return this;
    }

    @Override
    public IMetaverseBuilder updateLinkLabel(IMetaverseLink link, String label) {
        if (label != null && this.deleteLink(link, false)) {
            link.setLabel(label);
            this.addLink(link);
        }
        return this;
    }

    @Override
    public IMetaverseObjectFactory getMetaverseObjectFactory() {
        if (this.metaverseObjectFactory == null) {
            IMetaverseObjectFactory pentahoSystemMetaverseObjectFactory = (IMetaverseObjectFactory)PentahoSystem.get(IMetaverseObjectFactory.class);
            this.metaverseObjectFactory = pentahoSystemMetaverseObjectFactory != null ? pentahoSystemMetaverseObjectFactory : this;
        }
        return this.metaverseObjectFactory;
    }

    @Override
    public void setMetaverseObjectFactory(IMetaverseObjectFactory metaverseObjectFactory) {
        this.metaverseObjectFactory = metaverseObjectFactory;
    }

    @Override
    public IMetaverseBuilder updateNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v != null) {
            this.copyNodePropertiesToVertex(node, v);
        }
        return this;
    }

    @Override
    public IMetaverseBuilder addLink(IMetaverseNode fromNode, String label, IMetaverseNode toNode) {
        IMetaverseLink link = this.createLinkObject();
        link.setFromNode(fromNode);
        link.setLabel(label);
        link.setToNode(toNode);
        return this.addLink(link);
    }

    @Override
    public void addLink(Vertex fromVertex, String label, Vertex toVertex) {
        this.addEdge(fromVertex, label, toVertex);
    }

    private Edge addEdge(Vertex fromVertex, String label, Vertex toVertex) {
        return this.addEdge(fromVertex, label, toVertex, true);
    }

    private Edge addEdge(Vertex fromVertex, String label, Vertex toVertex, boolean addLabel) {
        String edgeId = BaseMetaverseBuilder.getEdgeId(fromVertex, label, toVertex);
        Edge edge = this.graph.getEdge((Object)edgeId);
        if (edge == null) {
            edge = this.graph.addEdge((Object)edgeId, fromVertex, toVertex, label);
            if (addLabel) {
                edge.setProperty("text", (Object)label);
            }
        }
        return edge;
    }

    public boolean isVirtual(Vertex vertex) {
        if (vertex == null) {
            return false;
        }
        Boolean isVirtual = (Boolean)vertex.getProperty("virtual");
        return isVirtual == null ? false : isVirtual;
    }
}

