/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcResultSet
extends TraceObject
implements ResultSet {
    private final boolean closeStatement;
    private final boolean scrollable;
    private final boolean updatable;
    private ResultInterface result;
    private JdbcConnection conn;
    private JdbcStatement stat;
    private int columnCount;
    private boolean wasNull;
    private Value[] insertRow;
    private Value[] updateRow;
    private HashMap<String, Integer> columnLabelMap;
    private HashMap<Integer, Value[]> patchedRows;

    JdbcResultSet(JdbcConnection jdbcConnection, JdbcStatement jdbcStatement, ResultInterface resultInterface, int n, boolean bl, boolean bl2, boolean bl3) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 4, n);
        this.conn = jdbcConnection;
        this.stat = jdbcStatement;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        this.closeStatement = bl;
        this.scrollable = bl2;
        this.updatable = bl3;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.nextRow();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int n = this.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n, "getMetaData()");
            }
            this.checkClosed();
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(this, null, this.result, string, this.conn.getSession().getTrace(), n);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try {
            this.debugCodeCall("findColumn", string);
            return this.getColumnIndex(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws SQLException {
        if (this.result != null) {
            try {
                this.result.close();
                if (this.closeStatement && this.stat != null) {
                    this.stat.close();
                }
            }
            finally {
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            if (this.closeStatement) {
                return null;
            }
            return this.stat;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            this.debugCodeCall("getString", n);
            return this.get(n).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        try {
            this.debugCodeCall("getString", string);
            return this.get(string).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        try {
            this.debugCodeCall("getInt", n);
            return this.get(n).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        try {
            this.debugCodeCall("getInt", string);
            return this.get(string).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", n);
            return this.get(n).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        try {
            this.debugCodeCall("getDate", n);
            return this.get(n).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            this.debugCodeCall("getTime", n);
            return this.get(n).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", n);
            return this.get(n).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", string);
            return this.get(string).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        try {
            this.debugCodeCall("getDate", string);
            return this.get(string).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        try {
            this.debugCodeCall("getTime", string);
            return this.get(string).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", string);
            return this.get(string).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            this.debugCodeCall("getObject", n);
            Value value = this.get(n);
            return this.conn.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        try {
            this.debugCodeCall("getObject", string);
            Value value = this.get(string);
            return this.conn.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", n);
            Boolean bl = this.get(n).getBoolean();
            return bl == null ? false : bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", string);
            Boolean bl = this.get(string).getBoolean();
            return bl == null ? false : bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        try {
            this.debugCodeCall("getByte", n);
            return this.get(n).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        try {
            this.debugCodeCall("getByte", string);
            return this.get(string).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        try {
            this.debugCodeCall("getShort", n);
            return this.get(n).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        try {
            this.debugCodeCall("getShort", string);
            return this.get(string).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        try {
            this.debugCodeCall("getLong", n);
            return this.get(n).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        try {
            this.debugCodeCall("getLong", string);
            return this.get(string).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        try {
            this.debugCodeCall("getFloat", n);
            return this.get(n).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        try {
            this.debugCodeCall("getFloat", string);
            return this.get(string).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        try {
            this.debugCodeCall("getDouble", n);
            return this.get(n).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        try {
            this.debugCodeCall("getDouble", string);
            return this.get(string).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + StringUtils.quoteJavaString(string) + ", " + n + ");");
            }
            if (n < 0) {
                throw DbException.getInvalidValueException("" + n, "scale");
            }
            BigDecimal bigDecimal = this.get(string).getBigDecimal();
            return bigDecimal == null ? null : MathUtils.setScale(bigDecimal, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + n + ", " + n2 + ");");
            }
            if (n2 < 0) {
                throw DbException.getInvalidValueException("" + n2, "scale");
            }
            BigDecimal bigDecimal = this.get(n).getBigDecimal();
            return bigDecimal == null ? null : MathUtils.setScale(bigDecimal, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + n + ", calendar)");
            }
            Date date = this.get(n).getDate();
            return DateTimeUtils.convertDateToCalendar(date, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Date date = this.get(string).getDate();
            return DateTimeUtils.convertDateToCalendar(date, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + n + ", calendar)");
            }
            Time time = this.get(n).getTime();
            return DateTimeUtils.convertTimeToCalendar(time, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Time time = this.get(string).getTime();
            return DateTimeUtils.convertTimeToCalendar(time, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + n + ", calendar)");
            }
            Timestamp timestamp = this.get(n).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(timestamp, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Timestamp timestamp = this.get(string).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(timestamp, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            int n2 = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, n2, "getBlob(" + n + ")");
            Value value = this.get(n);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            int n = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, n, "getBlob(" + this.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, value, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            this.debugCodeCall("getBytes", n);
            return this.get(n).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            this.debugCodeCall("getBytes", string);
            return this.get(string).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", n);
            return this.get(n).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", string);
            return this.get(string).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            int n2 = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, n2, "getClob(" + n + ")");
            Value value = this.get(n);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            int n = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, n, "getClob(" + this.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            int n2 = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, n2, "getArray(" + n + ")");
            Value value = this.get(n);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        try {
            int n = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, n, "getArray(" + this.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, value, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", n);
            String string = this.get(n).getString();
            return string == null ? null : IOUtils.getInputStream(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", string);
            String string2 = this.get(string).getString();
            return IOUtils.getInputStream(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", n);
            return this.get(n).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", string);
            return this.get(string).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        try {
            this.debugCodeCall("updateNull", n);
            this.update(n, (Value)ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        try {
            this.debugCodeCall("updateNull", string);
            this.update(string, (Value)ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + n + ", " + bl + ");");
            }
            this.update(n, (Value)ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + this.quote(string) + ", " + bl + ");");
            }
            this.update(string, (Value)ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + n + ", " + by + ");");
            }
            this.update(n, (Value)ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + string + ", " + by + ");");
            }
            this.update(string, (Value)ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + n + ", x);");
            }
            this.update(n, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + this.quote(string) + ", x);");
            }
            this.update(string, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + n + ", (short) " + s + ");");
            }
            this.update(n, (Value)ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + this.quote(string) + ", (short) " + s + ");");
            }
            this.update(string, (Value)ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + n + ", " + n2 + ");");
            }
            this.update(n, (Value)ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + this.quote(string) + ", " + n + ");");
            }
            this.update(string, (Value)ValueInt.get(n));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + n + ", " + l + "L);");
            }
            this.update(n, (Value)ValueLong.get(l));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + this.quote(string) + ", " + l + "L);");
            }
            this.update(string, (Value)ValueLong.get(l));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + n + ", " + f + "f);");
            }
            this.update(n, (Value)ValueFloat.get(f));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + this.quote(string) + ", " + f + "f);");
            }
            this.update(string, (Value)ValueFloat.get(f));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + n + ", " + d + "d);");
            }
            this.update(n, (Value)ValueDouble.get(d));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + this.quote(string) + ", " + d + "d);");
            }
            this.update(string, (Value)ValueDouble.get(d));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + n + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            this.update(n, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + this.quote(string) + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            this.update(string, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + n + ", " + this.quote(string) + ");");
            }
            this.update(n, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + this.quote(string) + ", " + this.quote(string2) + ");");
            }
            this.update(string, string2 == null ? ValueNull.INSTANCE : ValueString.get(string2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + n + ", x);");
            }
            this.update(n, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + this.quote(string) + ", x);");
            }
            this.update(string, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + n + ", x);");
            }
            this.update(n, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + this.quote(string) + ", x);");
            }
            this.update(string, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + n + ", x);");
            }
            this.update(n, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + this.quote(string) + ", x);");
            }
            this.update(string, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, inputStream, (long)n2);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(string, inputStream, (long)n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(string, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + this.quote(string) + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(string, inputStream, (long)n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + this.quote(string) + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(string, reader, (long)n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + this.quote(string) + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n + ", x, " + n2 + ");");
            }
            this.update(n, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + this.quote(string) + ", x, " + n + ");");
            }
            this.update(string, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n + ", x);");
            }
            this.update(n, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + this.quote(string) + ", x);");
            }
            this.update(string, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBlob(n, inputStream, -1L);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + this.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(string, inputStream, -1L);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + this.quote(string) + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateClob(n, reader, -1L);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.update(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + this.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(string, reader, -1L);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + this.quote(string) + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.unsupported("cursorName");
    }

    @Override
    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            int n = this.result.getRowId();
            if (n >= this.result.getRowCount()) {
                return 0;
            }
            return n + 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            if (!this.updatable) {
                return 1007;
            }
            UpdatableRow updatableRow = new UpdatableRow(this.conn, this.result);
            return updatableRow.isUpdatable() ? 1008 : 1007;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.result.getFetchSize();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n);
            this.checkClosed();
            if (n < 0) {
                throw DbException.getInvalidValueException("" + n, "rows");
            }
            if (n > 0) {
                int n2;
                if (this.stat != null && (n2 = this.stat.getMaxRows()) > 0 && n > n2) {
                    throw DbException.getInvalidValueException("" + n, "rows");
                }
            } else {
                n = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.result.setFetchSize(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw this.unsupported("setFetchDirection");
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.stat == null ? 1003 : this.stat.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            return this.result.getRowId() < 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            int n = this.result.getRowId();
            int n2 = this.result.getRowCount();
            return n >= n2 || n2 == 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            int n = this.result.getRowId();
            return n == 0 && n < this.result.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            int n = this.result.getRowId();
            return n >= 0 && n == this.result.getRowCount() - 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            if (this.result.getRowId() >= 0) {
                this.resetResult();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.nextRow()) {
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            if (this.result.getRowId() < 0) {
                return this.nextRow();
            }
            this.resetResult();
            return this.nextRow();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            return this.absolute(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        try {
            this.debugCodeCall("absolute", n);
            this.checkClosed();
            if (n < 0) {
                n = this.result.getRowCount() + n + 1;
            } else if (n > this.result.getRowCount() + 1) {
                n = this.result.getRowCount() + 1;
            }
            if (n <= this.result.getRowId()) {
                this.resetResult();
            }
            while (this.result.getRowId() + 1 < n) {
                this.nextRow();
            }
            int n2 = this.result.getRowId();
            return n2 >= 0 && n2 < this.result.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        try {
            this.debugCodeCall("relative", n);
            this.checkClosed();
            int n2 = this.result.getRowId() + 1 + n;
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.result.getRowCount()) {
                n2 = this.result.getRowCount() + 1;
            }
            return this.absolute(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.checkUpdatable();
            this.insertRow = new Value[this.columnCount];
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.checkUpdatable();
            this.insertRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.checkUpdatable();
            if (this.insertRow == null) {
                throw DbException.get(90029);
            }
            this.getUpdatableRow().insertRow(this.insertRow);
            this.insertRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            if (this.updateRow != null) {
                int n;
                UpdatableRow updatableRow = this.getUpdatableRow();
                Value[] valueArray = new Value[this.columnCount];
                for (n = 0; n < this.updateRow.length; ++n) {
                    valueArray[n] = this.get(n + 1);
                }
                updatableRow.updateRow(valueArray, this.updateRow);
                for (n = 0; n < this.updateRow.length; ++n) {
                    if (this.updateRow[n] != null) continue;
                    this.updateRow[n] = valueArray[n];
                }
                Value[] valueArray2 = updatableRow.readRow(this.updateRow);
                this.patchCurrentRow(valueArray2);
                this.updateRow = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().deleteRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.checkOnValidRow();
            this.patchCurrentRow(this.getUpdatableRow().readRow(this.result.currentRow()));
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private UpdatableRow getUpdatableRow() throws SQLException {
        UpdatableRow updatableRow = new UpdatableRow(this.conn, this.result);
        if (!updatableRow.isUpdatable()) {
            throw DbException.get(90127);
        }
        return updatableRow;
    }

    private int getColumnIndex(String string) throws SQLException {
        int n;
        this.checkClosed();
        if (string == null) {
            throw DbException.getInvalidValueException("columnLabel", null);
        }
        if (this.columnCount >= SysProperties.MIN_COLUMN_NAME_MAP) {
            Serializable serializable;
            if (this.columnLabelMap == null) {
                String string2;
                int n2;
                serializable = New.hashMap(this.columnCount);
                for (n2 = 0; n2 < this.columnCount; ++n2) {
                    string2 = this.result.getColumnName(n2);
                    if (string2 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string2);
                    ((HashMap)serializable).put(string2, n2);
                    String string3 = this.result.getTableName(n2);
                    if (string3 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string3) + "." + string2;
                    ((HashMap)serializable).put(string2, n2);
                }
                for (n2 = 0; n2 < this.columnCount; ++n2) {
                    string2 = StringUtils.toUpperEnglish(this.result.getAlias(n2));
                    ((HashMap)serializable).put(string2, n2);
                }
                this.columnLabelMap = serializable;
            }
            if ((serializable = this.columnLabelMap.get(StringUtils.toUpperEnglish(string))) == null) {
                throw DbException.get(42122, string);
            }
            return (Integer)serializable + 1;
        }
        for (n = 0; n < this.columnCount; ++n) {
            if (!string.equalsIgnoreCase(this.result.getAlias(n))) continue;
            return n + 1;
        }
        n = string.indexOf(46);
        if (n > 0) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            for (int i = 0; i < this.columnCount; ++i) {
                if (!string4.equalsIgnoreCase(this.result.getTableName(i)) || !string5.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!string.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        }
        throw DbException.get(42122, string);
    }

    private void checkColumnIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.columnCount) {
            throw DbException.getInvalidValueException("" + n, "columnIndex");
        }
    }

    void checkClosed() throws SQLException {
        if (this.result == null) {
            throw DbException.get(90007);
        }
        if (this.stat != null) {
            this.stat.checkClosed();
        }
        if (this.conn != null) {
            this.conn.checkClosed();
        }
    }

    private void checkOnValidRow() {
        if (this.result.getRowId() < 0 || this.result.getRowId() >= this.result.getRowCount()) {
            throw DbException.get(2000);
        }
    }

    private Value get(int n) throws SQLException {
        Value[] valueArray;
        this.checkColumnIndex(n);
        this.checkOnValidRow();
        if (this.patchedRows == null) {
            valueArray = this.result.currentRow();
        } else {
            valueArray = this.patchedRows.get(this.result.getRowId());
            if (valueArray == null) {
                valueArray = this.result.currentRow();
            }
        }
        Value value = valueArray[n - 1];
        this.wasNull = value == ValueNull.INSTANCE;
        return value;
    }

    private Value get(String string) throws SQLException {
        int n = this.getColumnIndex(string);
        return this.get(n);
    }

    private void update(String string, Value value) throws SQLException {
        int n = this.getColumnIndex(string);
        this.update(n, value);
    }

    private void update(int n, Value value) throws SQLException {
        this.checkUpdatable();
        this.checkColumnIndex(n);
        if (this.insertRow != null) {
            this.insertRow[n - 1] = value;
        } else {
            if (this.updateRow == null) {
                this.updateRow = new Value[this.columnCount];
            }
            this.updateRow[n - 1] = value;
        }
    }

    private boolean nextRow() {
        boolean bl = this.result.next();
        if (!bl && !this.scrollable) {
            this.result.close();
        }
        return bl;
    }

    private void resetResult() {
        if (!this.scrollable) {
            throw DbException.get(90128);
        }
        this.result.reset();
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.conn.getHoldability();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.result == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.result;
    }

    private void patchCurrentRow(Value[] valueArray) {
        boolean bl = false;
        Value[] valueArray2 = this.result.currentRow();
        CompareMode compareMode = this.conn.getCompareMode();
        for (int i = 0; i < valueArray.length; ++i) {
            if (valueArray[i].compareTo(valueArray2[i], compareMode) == 0) continue;
            bl = true;
            break;
        }
        if (this.patchedRows == null) {
            this.patchedRows = New.hashMap();
        }
        Integer n = this.result.getRowId();
        if (!bl) {
            this.patchedRows.remove(n);
        } else {
            this.patchedRows.put(n, valueArray);
        }
    }

    private Value convertToUnknownValue(Object object) throws SQLException {
        this.checkClosed();
        return DataType.convertToValue(this.conn.getSession(), object, -1);
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.updatable) {
            throw DbException.get(90140);
        }
    }
}

