/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CdfHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HashMap<String, String[]> paramMap = new HashMap();

    public CdfHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String key) {
        if (this.paramMap.containsKey(key)) {
            return this.paramMap.get(key)[0];
        }
        return super.getRequest().getParameter(key);
    }

    public Map getParameterMap() {
        if (this.paramMap.size() == 0) {
            return super.getRequest().getParameterMap();
        }
        HashMap<String, String[]> fullParamMap = new HashMap<String, String[]>();
        fullParamMap.putAll(super.getRequest().getParameterMap());
        fullParamMap.putAll(this.paramMap);
        return Collections.unmodifiableMap(fullParamMap);
    }

    public Enumeration getParameterNames() {
        if (this.paramMap.size() == 0) {
            return super.getRequest().getParameterNames();
        }
        HashSet keys = new HashSet(Collections.list(super.getRequest().getParameterNames()));
        keys.addAll(this.paramMap.keySet());
        return Collections.enumeration(keys);
    }

    public String[] getParameterValues(String key) {
        if (this.paramMap.containsKey(key)) {
            return this.paramMap.get(key);
        }
        return super.getRequest().getParameterValues(key);
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] value) {
        this.paramMap.put(name, value);
    }

    public void addParameters(HashMap<String, String[]> params) {
        this.paramMap.putAll(params);
    }
}

