/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.export;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.export.IExport;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.web.http.HttpOutputHandler;

public abstract class Export
extends PentahoBase
implements IExport {
    protected static final Log logger = LogFactory.getLog(Export.class);
    protected HttpOutputHandler httpHandler = null;
    protected OutputStream outputStream = null;

    public Export(OutputStream out) throws IOException {
        this.outputStream = out;
    }

    public Log getLogger() {
        return logger;
    }

    public void exportFile(JSONObject resultSet) {
        try {
            JSONArray metaData = resultSet.getJSONArray("metadata");
            JSONArray values = resultSet.getJSONArray("values");
            String[][] results = new String[1][1];
            results[0][0] = "No results Returned";
            int nCols = 0;
            int nRows = 0;
            if (metaData.length() > 0 && (nRows = values.length()) > 0 && values.length() > 0 && (nCols = values.getJSONArray(0).length()) > 0) {
                int i;
                results = new String[nRows + 1][nCols + 1];
                results[0][0] = "";
                for (i = 0; i < metaData.length(); ++i) {
                    results[0][i + 1] = metaData.getString(i);
                }
                for (i = 0; i < nRows; ++i) {
                    JSONArray row = values.getJSONArray(i);
                    for (int j = 0; j < nCols; ++j) {
                        results[i + 1][j] = row.getString(j);
                    }
                }
            }
            this.export(results);
        }
        catch (JSONException e) {
            logger.error((Object)Messages.getErrorString((String)"CdfExpor.ERROR_0001_PARSING_RESULTS"));
        }
    }

    public boolean isDouble(String obj) {
        try {
            Double.parseDouble(obj);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

