/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.embed;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.util.messages.LocaleHelper;

public class EmbeddedHeadersGenerator {
    static final String DEPRECATED_COMMENT = "\n/** @deprecated - use 'pentaho/environment' module's variable instead */";
    static final String INITIAL_COMMENT = "/** This file is generated in cdf to allow using cdf embedded.\nIt will append to the head tag the dependencies needed, like the FULLY_QUALIFIED_URL**/\n\n";
    static final String REQUIRE_JS_CFG_START = "var requireCfg = {waitSeconds: 30, paths: {}, shim: {}, map: {\"*\": {}}, bundles: {}, config: {\"pentaho/modules\": {}}, packages: []};\n\n";
    static final String REQUIRE_DASHBOARD_CONTEXT_CONFIGURATION = "requireCfg.config[''cdf/dashboard/Dashboard''] = {0};\n";
    static final String REQUIRE_PATH = "content/common-ui/resources/web/require.js";
    static final String REQUIRE_START_PATH = "content/common-ui/resources/web/require-cfg.js";
    static final String REQUIRE_INIT_PATH = "osgi/requirejs-manager/js/require-init.js?requirejs=false&useFullyQualifiedUrl=true";
    private static final String CONTEXT_PATH_BUILDER = "\nvar CONTEXT_PATH = ''{0}'';\n";
    private static final String FULL_QUALIFIED_URL_BUILDER = "\nvar FULL_QUALIFIED_URL = ''{0}'';\n";
    private static final String SERVER_PROTOCOL_BUILDER = "\nvar SERVER_PROTOCOL = ''{0}'';\n";
    private static final String SESSION_NAME_BUILDER = "\nvar SESSION_NAME = ''{0}'';\n";
    private static final String LOCALE_BUILDER = "\nvar SESSION_LOCALE = ''{0}'';\n";
    private static final String HOME_FOLDER_BUILDER = "\nvar HOME_FOLDER = ''{0}'';\n";
    private static final String RESERVED_CHARS_BUILDER = "\nvar RESERVED_CHARS = ''{0}'';\n";
    private static final String RESERVED_CHARS_DISPLAY_BUILDER = "\nvar RESERVED_CHARS_DISPLAY = ''{0}'';\n";
    private static final String RESERVED_CHARS_REGEX_PATTERN_BUILDER = "\nvar RESERVED_CHARS_REGEX_PATTERN = /{0}/;\n";
    static final String DOCUMENT_SCRIPT = "document.write(\"<script language=''javascript'' type=''text/javascript'' src=''{0}''></script>\");\n";
    private static final String REQUIRE_JS = "requirejs";
    private static final String JS = ".js";
    protected Locale locale = LocaleHelper.getLocale();
    protected String serverProtocol;
    protected String fullQualifiedURL;
    protected String contextConfiguration;

    public EmbeddedHeadersGenerator(String fullUrl, String contextConfiguration) {
        this.serverProtocol = fullUrl.startsWith("http") ? fullUrl.substring(0, fullUrl.indexOf(":")) : "http";
        this.fullQualifiedURL = fullUrl;
        this.contextConfiguration = contextConfiguration;
    }

    public String generate() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.printScriptsContext()).append(this.printRequireJs()).append(this.printEnvironmentConfig()).append(this.printUrlContext()).append(this.printSessionName()).append(this.printLocale()).append(this.printHomeFolder()).append(this.printReservedChars()).append(this.printReservedCharsDisplay()).append(this.printReservedRegexPattern()).append(this.printRequireJsInit());
        return sb.toString();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String printScriptsContext() {
        StringBuilder sb = new StringBuilder();
        sb.append(INITIAL_COMMENT).append(REQUIRE_JS_CFG_START).append(MessageFormat.format(REQUIRE_DASHBOARD_CONTEXT_CONFIGURATION, this.contextConfiguration)).append("// injecting document writes to append the cdf require files\n");
        List<String> contextScripts = this.getContextScripts();
        for (String s : contextScripts) {
            sb.append(MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + s));
        }
        return sb.toString();
    }

    private String printRequireJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + REQUIRE_PATH)).append(MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + REQUIRE_START_PATH));
        return sb.toString();
    }

    protected String printEnvironmentConfig() {
        String userID = this.getSessionName();
        String userHomeFolder = this.getUserHomeFolderPath();
        StringBuilder reservedChars = new StringBuilder();
        for (char reserved : this.getReservedChars()) {
            reservedChars.append(reserved);
        }
        return "\nrequireCfg.config[\"pentaho/environment\"] = {\n  application: \"pentaho-cdf\",\n  theme: null,\n  locale: \"" + this.locale + "\",\n  user: {\n    id: \"" + userID + "\",\n    home: \"" + userHomeFolder + "\"\n  },\n  server: {\n    root: \"" + this.fullQualifiedURL + "\"\n  },\n  reservedChars: \"" + this.escapeEnvironmentVariable(reservedChars.toString()) + "\"\n};\n";
    }

    protected String printUrlContext() {
        String contextPath = DEPRECATED_COMMENT + MessageFormat.format(CONTEXT_PATH_BUILDER, this.fullQualifiedURL);
        String fullQualifiedUrl = DEPRECATED_COMMENT + MessageFormat.format(FULL_QUALIFIED_URL_BUILDER, this.fullQualifiedURL);
        String serverProtocol = DEPRECATED_COMMENT + MessageFormat.format(SERVER_PROTOCOL_BUILDER, this.serverProtocol);
        return contextPath + fullQualifiedUrl + serverProtocol;
    }

    protected String printSessionName() throws IOException {
        return DEPRECATED_COMMENT + MessageFormat.format(SESSION_NAME_BUILDER, this.getSessionName());
    }

    protected String printLocale() throws IOException {
        return DEPRECATED_COMMENT + MessageFormat.format(LOCALE_BUILDER, this.locale.toString());
    }

    protected String printHomeFolder() throws IOException {
        return DEPRECATED_COMMENT + MessageFormat.format(HOME_FOLDER_BUILDER, this.getUserHomeFolderPath());
    }

    protected String printReservedChars() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (char c : this.getReservedChars()) {
            sb.append(c);
        }
        String reservedChars = this.escapeEnvironmentVariable(sb.toString());
        return DEPRECATED_COMMENT + MessageFormat.format(RESERVED_CHARS_BUILDER, reservedChars);
    }

    protected String printReservedCharsDisplay() throws IOException {
        List<Character> reservedCharacters = this.getReservedChars();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < reservedCharacters.size(); ++i) {
            if (reservedCharacters.get(i).charValue() >= '\u0007' && reservedCharacters.get(i).charValue() <= '\r') {
                sb.append(StringEscapeUtils.escapeJava((String)("" + reservedCharacters.get(i))));
            } else {
                sb.append(reservedCharacters.get(i));
            }
            if (i + 1 >= reservedCharacters.size()) continue;
            sb.append(", ");
        }
        String reservedCharsDisplay = this.escapeEnvironmentVariable(sb.toString());
        return DEPRECATED_COMMENT + MessageFormat.format(RESERVED_CHARS_DISPLAY_BUILDER, reservedCharsDisplay);
    }

    protected String printReservedRegexPattern() throws IOException {
        return DEPRECATED_COMMENT + MessageFormat.format(RESERVED_CHARS_REGEX_PATTERN_BUILDER, this.makeReservedCharPattern());
    }

    protected String printRequireJsInit() {
        return MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + REQUIRE_INIT_PATH);
    }

    private String makeReservedCharPattern() {
        StringBuilder buf = new StringBuilder();
        buf.append(".*[");
        for (Character ch : this.getReservedChars()) {
            buf.append(this.escapeEnvironmentVariable(ch.toString()));
        }
        buf.append("]+.*");
        return buf.toString();
    }

    protected String getSessionName() {
        IPentahoSession session = this.getPentahoSession();
        if (session == null) {
            return "null";
        }
        return this.escapeEnvironmentVariable(session.getName());
    }

    protected String getUserHomeFolderPath() {
        IPentahoSession session = this.getPentahoSession();
        if (session == null) {
            return "null";
        }
        String sessionName = this.escapeEnvironmentVariable(session.getName());
        return ClientRepositoryPaths.getUserHomeFolderPath((String)sessionName);
    }

    protected List<Character> getReservedChars() {
        return JcrRepositoryFileUtils.getReservedChars();
    }

    protected List<String> getContextScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        List externalResources = pluginManager.getExternalResourcesForContext(REQUIRE_JS);
        for (String res : externalResources) {
            if (res == null || !res.endsWith(JS)) continue;
            scripts.add(res);
        }
        return scripts;
    }

    private String escapeEnvironmentVariable(String value) {
        if (value == null) {
            return "null";
        }
        return StringEscapeUtils.escapeJavaScript((String)value);
    }

    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }
}

