/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.embed;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.pentaho.cdf.embed.EmbeddedHeadersGenerator;

public class EmbeddedHeadersCallbackGenerator
extends EmbeddedHeadersGenerator {
    static final String DOCUMENT_SCRIPT_START = "new Promise(function (resolve, reject) {";
    static final String DOCUMENT_SCRIPT = "loadScript(''{0}'').then( () => '{'\n";
    static final String DOCUMENT_SCRIPT_CALLBACK = "loadScript(''{0}'').then( () => '{'\n{1}\n";
    static final String DOCUMENT_SCRIPT_CALLBACK_CALL = "if({0}) {0}();";
    static final String DOCUMENT_SCRIPT_END = "})";
    static final String DOCUMENT_SCRIPT_CHAIN_END = ";\n";
    protected String callbackFunctionName = "undefined";

    public EmbeddedHeadersCallbackGenerator(String fullUrl, String contextConfiguration) {
        super(fullUrl, contextConfiguration);
    }

    @Override
    public String generate() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.printUrlContext()).append(this.printSessionName()).append(this.printLocale()).append(this.printHomeFolder()).append(this.printReservedChars()).append(this.printReservedCharsDisplay()).append(this.printReservedRegexPattern()).append(this.printScriptsContext());
        return sb.toString();
    }

    public void setCallbackFunctionName(String callbackFunctionName) {
        this.callbackFunctionName = callbackFunctionName;
    }

    protected String printScriptsContext() {
        StringBuilder sb = new StringBuilder();
        sb.append("/** This file is generated in cdf to allow using cdf embedded.\nIt will append to the head tag the dependencies needed, like the FULLY_QUALIFIED_URL**/\n\n").append("var requireCfg = {waitSeconds: 30, paths: {}, shim: {}, map: {\"*\": {}}, bundles: {}, config: {\"pentaho/modules\": {}}, packages: []};\n\n").append(this.printEnvironmentConfig()).append(MessageFormat.format("requireCfg.config[''cdf/dashboard/Dashboard''] = {0};\n", this.contextConfiguration)).append("// loading the cdf require files\n").append("function loadScript(src) {\n  return new Promise(function (resolve, reject) {\n    var newScriptElement;\n    newScriptElement = document.createElement('script');\n    newScriptElement.src = src;\n    newScriptElement.async = true;\n    newScriptElement.onload = resolve;\n    newScriptElement.onerror = reject;\n    document.head.appendChild(newScriptElement);\n  });\n}\n");
        sb.append(DOCUMENT_SCRIPT_START);
        List<String> contextScripts = this.getContextScripts();
        for (String s : contextScripts) {
            sb.append(MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + s));
        }
        String callbackCall = MessageFormat.format(DOCUMENT_SCRIPT_CALLBACK_CALL, this.callbackFunctionName);
        sb.append(MessageFormat.format(DOCUMENT_SCRIPT, this.fullQualifiedURL + "content/common-ui/resources/web/require.js")).append(MessageFormat.format(DOCUMENT_SCRIPT_CALLBACK, this.fullQualifiedURL + "content/common-ui/resources/web/require-cfg.js", callbackCall));
        for (int i = 0; i < contextScripts.size(); ++i) {
            sb.append(DOCUMENT_SCRIPT_END);
        }
        sb.append(DOCUMENT_SCRIPT_END).append(DOCUMENT_SCRIPT_END);
        sb.append(DOCUMENT_SCRIPT_END).append(DOCUMENT_SCRIPT_CHAIN_END);
        return sb.toString();
    }
}

