/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.context;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.context.autoinclude.AutoInclude;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.storage.StorageEngine;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityParameterProvider;
import pt.webdetails.cpf.InterPluginCall;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;
import pt.webdetails.cpf.utils.PluginIOUtils;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public class ContextEngine {
    private static final Log logger = LogFactory.getLog(ContextEngine.class);
    private static final String PREFIX_PARAMETER = "param";
    private static boolean legacyDashboardContext;
    private static ContextEngine instance;
    private static String CONFIG_FILE;
    private static List<AutoInclude> autoIncludes;
    private static Object autoIncludesLock;

    public ContextEngine() {
        legacyDashboardContext = Boolean.valueOf(StringUtils.defaultIfEmpty((String)CdfEngine.getEnvironment().getResourceLoader().getPluginSetting(ContextEngine.class, "settings/legacy-dashboard-context"), (String)"false"));
    }

    public ContextEngine(boolean legacy) {
        legacyDashboardContext = legacy;
    }

    public static synchronized ContextEngine getInstance() {
        if (instance == null) {
            instance = new ContextEngine();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        List cacheFiles;
        Object object = autoIncludesLock;
        synchronized (object) {
            autoIncludes = null;
            logger.debug((Object)"auto-includes cleared.");
        }
        if (CdfEngine.getPluginSystemReader(null).fileExists("tmp/.cache") && (cacheFiles = CdfEngine.getPluginSystemReader(null).listFiles("tmp/.cache", new IBasicFileFilter(){

            public boolean accept(IBasicFile file) {
                return true;
            }
        })) != null) {
            for (IBasicFile file : cacheFiles) {
                CdfEngine.getEnvironment().getContentAccessFactory().getPluginSystemWriter(null).deleteFile(file.getPath());
            }
        }
    }

    public void generateContext(OutputStream out, HashMap<String, String> paramMap, int inactiveInterval) throws Exception {
        String dashboardContext;
        String solution = StringUtils.defaultIfEmpty((String)paramMap.get("solution"), (String)"");
        String path = StringUtils.defaultIfEmpty((String)paramMap.get("path"), (String)"");
        String file = StringUtils.defaultIfEmpty((String)paramMap.get("file"), (String)"");
        String action = StringUtils.defaultIfEmpty((String)paramMap.get("action"), (String)"");
        String fullPath = RepositoryHelper.joinPaths((String[])new String[]{solution, path, file});
        if (RepositoryHelper.getExtension((String)action).equals("xcdf")) {
            fullPath = RepositoryHelper.joinPaths((String[])new String[]{fullPath, action});
        }
        if (StringUtils.isEmpty((String)(dashboardContext = this.getContext(fullPath, paramMap, inactiveInterval)))) {
            logger.error((Object)"empty dashboardContext");
        }
        PluginIOUtils.writeOut((OutputStream)out, (String)dashboardContext);
    }

    protected IPentahoSession getUserSession() {
        return PentahoSessionHolder.getSession();
    }

    public String getContext(String path, Map<String, String> parameters, int inactiveInterval) {
        String username = this.getUserSession().getName();
        try {
            return this.buildContextScript(this.buildContext(path, username, parameters, inactiveInterval));
        }
        catch (JSONException e) {
            return "";
        }
    }

    public JSONObject buildContext(String path, String username, Map<String, String> parameters, int inactiveInterval) {
        JSONObject contextObj = new JSONObject();
        Document config = this.getConfigFile();
        try {
            this.buildContextConfig(contextObj, path, config);
            this.buildContextSessionTimeout(contextObj, inactiveInterval);
            this.buildContextDates(contextObj);
            contextObj.put("user", (Object)username);
            contextObj.put("locale", (Object)this.getLocale());
            this.buildContextPaths(contextObj, path, parameters);
            SecurityParameterProvider securityParams = this.getSecurityParams();
            contextObj.put("roles", securityParams.getParameter("principalRoles"));
            if (this.getLegacyStructure()) {
                this.buildLegacyStructure(contextObj, path, securityParams);
            }
            JSONObject params = new JSONObject();
            this.buildContextParams(params, parameters);
            contextObj.put("params", (Object)params);
            logger.info((Object)("[Timing] Finished building context: " + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date())));
        }
        catch (JSONException e) {
            logger.error((Object)"Error building context", (Throwable)e);
        }
        return contextObj;
    }

    protected JSONObject buildContextSessionTimeout(JSONObject contextObj, int inactiveInterval) throws JSONException {
        if (this.getUserSession().isAuthenticated()) {
            contextObj.put("sessionTimeout", inactiveInterval);
        }
        return contextObj;
    }

    protected JSONObject buildContextPaths(JSONObject contextObj, String dashboardPath, Map<String, String> parameters) throws JSONException {
        contextObj.put("path", (Object)dashboardPath);
        if (parameters != null && parameters.containsKey("solution")) {
            contextObj.put("solution", (Object)parameters.get("solution"));
        }
        return contextObj;
    }

    protected JSONObject buildContextDates(JSONObject contextObj) throws JSONException {
        Calendar cal = Calendar.getInstance();
        long utcTime = cal.getTimeInMillis();
        contextObj.put("serverLocalDate", utcTime + (long)cal.getTimeZone().getOffset(utcTime));
        contextObj.put("serverUTCDate", utcTime);
        return contextObj;
    }

    protected JSONObject buildLegacyStructure(JSONObject contextObj, String path, SecurityParameterProvider securityParams) throws JSONException {
        logger.warn((Object)"CDF: using legacy structure for Dashboard.context; this is a deprecated structure and should not be used. This is a configurable option via plugin's settings.xml");
        if (securityParams != null) {
            contextObj.put("isAdmin", (Object)Boolean.valueOf((String)securityParams.getParameter("principalAdministrator")));
        }
        if (!StringUtils.isEmpty((String)path)) {
            String[] parsedPath;
            boolean isPathToFile;
            if (!contextObj.has("fullPath")) {
                contextObj.put("fullPath", (Object)path);
            }
            if (path.startsWith(String.valueOf('/'))) {
                path = path.replaceFirst(String.valueOf('/'), "");
            }
            boolean bl = isPathToFile = !StringUtils.isEmpty((String)FilenameUtils.getExtension((String)path));
            if (isPathToFile) {
                contextObj.put("file", (Object)FilenameUtils.getName((String)path));
                path = path.replace(FilenameUtils.getName((String)path), "");
            }
            if ((parsedPath = (path = FilenameUtils.normalizeNoEndSeparator((String)path).replace(File.separatorChar, '/')).split(String.valueOf('/'))).length == 0) {
                contextObj.put("solution", (Object)"");
                contextObj.put("path", (Object)"");
            } else if (parsedPath.length == 1) {
                contextObj.put("solution", (Object)parsedPath[0]);
                contextObj.put("path", (Object)"");
            } else {
                contextObj.put("solution", (Object)parsedPath[0]);
                path = path.replace(FilenameUtils.getName((String)parsedPath[0]), "");
                path = path.replaceFirst(String.valueOf('/'), "");
                contextObj.put("path", (Object)path);
            }
        }
        return contextObj;
    }

    protected JSONObject buildContextConfig(JSONObject contextObj, String fullPath, Document config) throws JSONException {
        contextObj.put("queryData", (Object)this.processAutoIncludes(fullPath, config));
        contextObj.put("sessionAttributes", (Object)this.processSessionAttributes(config));
        return contextObj;
    }

    public String getConfig(String path, Map<String, String> parameters, int inactiveInterval) throws JSONException {
        String username = this.getUserSession().getName();
        StringBuilder s = new StringBuilder();
        s.append("{\n");
        s.append("context: ").append(this.buildContext(path, username, parameters, inactiveInterval));
        String storage = this.getStorage();
        if (!StringUtils.isEmpty((String)storage)) {
            s.append(",\nstorage: ").append(storage);
        }
        s.append("\n}");
        return s.toString();
    }

    protected String buildContextScript(JSONObject contextObj) throws JSONException {
        StringBuilder s = new StringBuilder();
        s.append("\n<script language=\"javascript\" type=\"text/javascript\">\n");
        s.append("Dashboards.context = ").append(contextObj.toString(2)).append("\n");
        String storage = this.getStorage();
        if (!StringUtils.isEmpty((String)storage)) {
            s.append("Dashboards.initialStorage = ").append(storage).append("\n");
        }
        s.append("\n</script>\n");
        return s.toString();
    }

    protected JSONObject buildContextParams(JSONObject contextObj, Map<String, String> params) throws JSONException {
        for (String param : params.keySet()) {
            if (!param.startsWith(PREFIX_PARAMETER)) continue;
            contextObj.put(param.substring(PREFIX_PARAMETER.length()), (Object)params.get(param));
        }
        return contextObj;
    }

    public JSONObject processSessionAttributes(Document config) {
        JSONObject result = new JSONObject();
        List attributes = config.selectNodes("//sessionattributes/attribute");
        for (Node attribute : attributes) {
            String name = attribute.getText();
            String key = XmlDom4JUtils.getNodeText((String)"@name", (Node)attribute);
            if (key == null) {
                key = name;
            }
            try {
                result.put(key, this.getUserSession().getAttribute(name));
            }
            catch (JSONException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    protected String getStorage() {
        try {
            return StorageEngine.getInstance().read(this.getUserSession().getName()).toString(2);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "";
        }
    }

    protected JSONObject processAutoIncludes(String dashboardPath, Document config) {
        JSONObject queries = new JSONObject();
        if (!this.cdaExists()) {
            logger.warn((Object)"Couldn't find CDA. Skipping auto-includes");
            return queries;
        }
        IUserContentAccess autoIncludesFolder = this.getUserContentAccess(null);
        if (!autoIncludesFolder.fileExists(this.getPluginRepositoryDir() + "/includes")) {
            return queries;
        }
        List<AutoInclude> autoIncludes = this.getAutoIncludes(config);
        for (AutoInclude autoInclude : autoIncludes) {
            if (!autoInclude.canInclude(dashboardPath)) continue;
            String cdaPath = autoInclude.getCdaPath();
            this.addCdaQuery(queries, cdaPath);
        }
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AutoInclude> getAutoIncludes(Document config) {
        Object object = autoIncludesLock;
        synchronized (object) {
            if (autoIncludes == null) {
                IUserContentAccess cdaRoot = this.getUserContentAccess(this.getPluginRepositoryDir() + "/includes");
                autoIncludes = this.buildAutoIncludeList(config, (IReadAccess)cdaRoot);
            }
            return autoIncludes;
        }
    }

    protected Document getConfigFile() {
        try {
            IContentAccessFactory factory = CdfEngine.getEnvironment().getContentAccessFactory();
            IReadAccess access = factory.getPluginRepositoryReader(null);
            if (!access.fileExists(CONFIG_FILE) && !(access = factory.getPluginSystemReader(null)).fileExists(CONFIG_FILE)) {
                logger.error((Object)(CONFIG_FILE + " not found!"));
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Reading %s from %s", CONFIG_FILE, access));
            }
            return XmlDom4JUtils.getDocumentFromStream((InputStream)access.getFileInputStream(CONFIG_FILE));
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't read context configuration file.", (Throwable)e);
            return null;
        }
    }

    protected boolean cdaExists() {
        return new InterPluginCall(InterPluginCall.CDA, "").pluginExists();
    }

    protected IUserContentAccess getUserContentAccess(String path) {
        return CdfEngine.getUserContentReader((String)path);
    }

    protected String getPluginRepositoryDir() {
        return CdfEngine.getEnvironment().getCdfPluginRepositoryDir();
    }

    protected void addCdaQuery(JSONObject queries, String cdaPath) {
        CdfEngine.getEnvironment().getCdfInterPluginBroker().addCdaQueries(queries, cdaPath);
    }

    protected List<AutoInclude> buildAutoIncludeList(Document config, IReadAccess cdaRoot) {
        return AutoInclude.buildAutoIncludeList(config, cdaRoot);
    }

    protected Locale getLocale() {
        return CdfEngine.getEnvironment().getLocale();
    }

    protected SecurityParameterProvider getSecurityParams() {
        return new SecurityParameterProvider(this.getUserSession());
    }

    protected boolean getLegacyStructure() {
        return legacyDashboardContext;
    }

    static {
        CONFIG_FILE = "dashboardContext.xml";
        autoIncludesLock = new Object();
    }
}

