/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.comments;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.comments.CommentsEngine;
import org.pentaho.cdf.utils.CorsUtil;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api/comments")
public class CommentsApi {
    private static final Log logger = LogFactory.getLog(CommentsApi.class);

    @GET
    @Path(value="/add")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public void add(@DefaultValue(value="") @QueryParam(value="page") String page, @DefaultValue(value="") @QueryParam(value="comment") String comment, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        try {
            this.addComment(page, comment, servletResponse);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding comment", (Throwable)e);
        }
    }

    @GET
    @Path(value="/list")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public void list(@DefaultValue(value="") @QueryParam(value="page") String page, @DefaultValue(value="0") @QueryParam(value="firstResult") int firstResult, @DefaultValue(value="20") @QueryParam(value="maxResults") int maxResults, @DefaultValue(value="false") @QueryParam(value="deleted") boolean deleted, @DefaultValue(value="false") @QueryParam(value="archived") boolean archived, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        boolean isAdministrator = this.isAdministrator();
        if (deleted && !isAdministrator) {
            deleted = false;
            logger.warn((Object)"only admin users are allowed to see deleted comments");
        }
        if (archived && !isAdministrator) {
            archived = false;
            logger.warn((Object)"only admin users are allowed to see archived comments");
        }
        try {
            this.listComments(page, firstResult, maxResults, deleted, archived, servletResponse);
        }
        catch (Exception e) {
            logger.error((Object)"Error listing comments", (Throwable)e);
        }
    }

    @GET
    @Path(value="/archive")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public void archive(@DefaultValue(value="0") @QueryParam(value="commentId") int commentId, @DefaultValue(value="true") @QueryParam(value="value") boolean value, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        if (!this.isAuthenticated()) {
            logger.error((Object)"Operation not authorized: requires authentication");
            return;
        }
        try {
            this.archiveComment(commentId, value, servletResponse);
        }
        catch (Exception e) {
            logger.error((Object)"Error archiving comment", (Throwable)e);
        }
    }

    @GET
    @Path(value="/delete")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public void delete(@DefaultValue(value="0") @QueryParam(value="commentId") int commentId, @DefaultValue(value="true") @QueryParam(value="value") boolean value, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        if (!this.isAuthenticated()) {
            logger.error((Object)"Operation not authorized: requires authentication");
            return;
        }
        try {
            this.deleteComment(commentId, value, servletResponse);
        }
        catch (Exception ex) {
            logger.error((Object)"Error deleting comment", (Throwable)ex);
        }
    }

    private String getUserName() {
        return PentahoSessionHolder.getSession().getName();
    }

    protected void setCorsHeaders(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        CorsUtil.getInstance().setCorsHeaders(servletRequest, servletResponse);
    }

    protected boolean isAdministrator() {
        return SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
    }

    protected boolean isAuthenticated() {
        return PentahoSessionHolder.getSession().isAuthenticated();
    }

    protected void addComment(String page, String comment, HttpServletResponse servletResponse) throws PluginHibernateException, JSONException, InvalidCdfOperationException, IOException {
        PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)CommentsEngine.getInstance().add(page, comment, this.getUserName()).toString(2));
    }

    protected void listComments(String page, int firstResult, int maxResults, boolean deleted, boolean archived, HttpServletResponse servletResponse) throws PluginHibernateException, JSONException, InvalidCdfOperationException, IOException {
        PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)CommentsEngine.getInstance().list(page, firstResult, maxResults, deleted, archived, this.getUserName()).toString(2));
    }

    protected void archiveComment(int commentId, boolean value, HttpServletResponse servletResponse) throws IOException, JSONException, PluginHibernateException {
        PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)CommentsEngine.getInstance().archive(commentId, value, this.getUserName(), this.isAdministrator()).toString(2));
    }

    protected void deleteComment(int commentId, boolean value, HttpServletResponse servletResponse) throws IOException, JSONException, PluginHibernateException {
        PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)CommentsEngine.getInstance().delete(commentId, value, this.getUserName(), this.isAdministrator()).toString(2));
    }
}

