/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.utils.CorsUtil;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.PluginResource;

@Path(value="/pentaho-cdf/api/resources")
public class ResourcesApi {
    @GET
    @Path(value="/{path: [^?]+ }")
    @Produces(value={"*/*"})
    public Response getSystemResource(@PathParam(value="path") String path, @Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        String pluginId = CdfEngine.getEnvironment().getPluginId();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (!StringUtils.isEmpty((String)path) && pluginManager.isPublic(pluginId, path)) {
            Response readFileResponse = new PluginResource(response).readFile(pluginId, path);
            CorsUtil.getInstance().setCorsHeaders(request, response);
            if (readFileResponse.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                return readFileResponse;
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

