/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.platform.web.servlet.ServletBase;
import pt.webdetails.cpf.MimeTypeHandler;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.PluginIOUtils;

public class GetCDFResource
extends ServletBase {
    private static final long serialVersionUID = 8251622066287622726L;
    private static final Log logger = LogFactory.getLog(GetCDFResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IReadAccess systemAccess = CdfEngine.getPluginSystemReader(null);
        String resource = request.getParameter("resource");
        if (StringUtils.isEmpty((String)resource)) {
            this.error(Messages.getErrorString((String)"GetResource.ERROR_0001_RESOURCE_PARAMETER_MISSING"));
            response.setStatus(503);
            return;
        }
        if (!systemAccess.fileExists(resource)) {
            this.error(Messages.getErrorString((String)"GetResource.ERROR_0003_RESOURCE_MISSING", (String)resource));
            response.setStatus(503);
            return;
        }
        InputStream in = systemAccess.getFileInputStream(resource);
        String mimeType = MimeTypeHandler.getMimeTypeFromFileName((String)resource);
        if (StringUtils.isEmpty((String)mimeType)) {
            response.setContentType("image/png");
        }
        response.setContentType(mimeType);
        response.setCharacterEncoding(CdfEngine.getEnvironment().getSystemEncoding());
        response.setHeader("expires", "0");
        ServletOutputStream out = response.getOutputStream();
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)out, (InputStream)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public Log getLogger() {
        return logger;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

