/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class AddColumnFamilyProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.AddColumnFamilyState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(AddColumnFamilyProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private TableName tableName;
    private HTableDescriptor unmodifiedHTableDescriptor;
    private HColumnDescriptor cfDescriptor;
    private UserGroupInformation user;
    private List<HRegionInfo> regionInfoList;
    private Boolean traceEnabled;

    public AddColumnFamilyProcedure() {
        this.unmodifiedHTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    public AddColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, HColumnDescriptor cfDescriptor) {
        this.tableName = tableName;
        this.cfDescriptor = cfDescriptor;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.unmodifiedHTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case ADD_COLUMN_FAMILY_PREPARE: {
                    this.prepareAdd(env);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preAdd(env, state);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case ADD_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case ADD_COLUMN_FAMILY_POST_OPERATION: {
                    this.postAdd(env, state);
                    this.setNextState(MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case ADD_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    this.reOpenAllRegionsIfTableIsOnline(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to add the column family" + this.getColumnFamilyName() + " to the table " + this.tableName + " (in state=" + state + ")"), (Throwable)e);
            this.setFailure("master-add-columnfamily", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case ADD_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    break;
                }
                case ADD_COLUMN_FAMILY_POST_OPERATION: {
                    break;
                }
                case ADD_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.restoreTableDescriptor(env);
                    break;
                }
                case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                    break;
                }
                case ADD_COLUMN_FAMILY_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step " + state + " for adding the column family" + this.getColumnFamilyName() + " to the table " + this.tableName), (Throwable)e);
            throw e;
        }
    }

    protected MasterProcedureProtos.AddColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.AddColumnFamilyState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.AddColumnFamilyState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.AddColumnFamilyState getInitialState() {
        return MasterProcedureProtos.AddColumnFamilyState.ADD_COLUMN_FAMILY_PREPARE;
    }

    protected void setNextState(MasterProcedureProtos.AddColumnFamilyState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("add-columnfamily", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized((Procedure)this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableExclusiveLock((Procedure)this, this.tableName);
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableExclusiveLock((Procedure)this, this.tableName);
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.AddColumnFamilyStateData.Builder addCFMsg = MasterProcedureProtos.AddColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setColumnfamilySchema(this.cfDescriptor.convert());
        if (this.unmodifiedHTableDescriptor != null) {
            addCFMsg.setUnmodifiedTableSchema(this.unmodifiedHTableDescriptor.convert());
        }
        addCFMsg.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.AddColumnFamilyStateData addCFMsg = MasterProcedureProtos.AddColumnFamilyStateData.parseDelimitedFrom((InputStream)stream);
        this.user = MasterProcedureUtil.toUserInfo(addCFMsg.getUserInfo());
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)addCFMsg.getTableName());
        this.cfDescriptor = HColumnDescriptor.convert((HBaseProtos.ColumnFamilySchema)addCFMsg.getColumnfamilySchema());
        if (addCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedHTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)addCFMsg.getUnmodifiedTableSchema());
        }
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.cfDescriptor != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareAdd(MasterProcedureEnv env) throws IOException {
        MasterDDLOperationHelper.checkTableModifiable(env, this.tableName);
        this.unmodifiedHTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedHTableDescriptor == null) {
            throw new IOException("HTableDescriptor missing for " + this.tableName);
        }
        if (this.unmodifiedHTableDescriptor.hasFamily(this.cfDescriptor.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + this.getColumnFamilyName() + "' in table '" + this.tableName + "' already exists so cannot be added");
        }
    }

    private void preAdd(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("AddColumn. Table = " + this.tableName + " HCD = " + this.cfDescriptor.toString()));
        HTableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (htd.hasFamily(this.cfDescriptor.getName())) {
            return;
        }
        htd.addFamily(this.cfDescriptor);
        env.getMasterServices().getTableDescriptors().add(htd);
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        HTableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (htd.hasFamily(this.cfDescriptor.getName())) {
            MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.tableName, this.getRegionInfoList(env), this.cfDescriptor.getName());
            env.getMasterServices().getTableDescriptors().add(this.unmodifiedHTableDescriptor);
            this.reOpenAllRegionsIfTableIsOnline(env);
        }
    }

    private void postAdd(MasterProcedureEnv env, MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void reOpenAllRegionsIfTableIsOnline(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) {
            return;
        }
        if (MasterDDLOperationHelper.reOpenAllRegions(env, this.getTableName(), this.getRegionInfoList(env))) {
            LOG.info((Object)("Completed add column family operation on table " + this.getTableName()));
        } else {
            LOG.warn((Object)("Error on reopening the regions on table " + this.getTableName()));
        }
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return this.cfDescriptor.getNameAsString();
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.AddColumnFamilyState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case ADD_COLUMN_FAMILY_PRE_OPERATION: {
                            cpHost.preAddColumnHandler(AddColumnFamilyProcedure.this.tableName, AddColumnFamilyProcedure.this.cfDescriptor);
                            break;
                        }
                        case ADD_COLUMN_FAMILY_POST_OPERATION: {
                            cpHost.postAddColumnHandler(AddColumnFamilyProcedure.this.tableName, AddColumnFamilyProcedure.this.cfDescriptor);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private List<HRegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        if (this.regionInfoList == null) {
            this.regionInfoList = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
        }
        return this.regionInfoList;
    }
}

