/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.KerberosToken;

public class KerberosTokenPolicyValidator
extends AbstractTokenPolicyValidator {
    private Message message;

    public KerberosTokenPolicyValidator(Message message) {
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim, KerberosSecurity kerberosToken) {
        Collection<AssertionInfo> krbAis = this.getAllAssertionsByLocalname(aim, "KerberosToken");
        if (!krbAis.isEmpty()) {
            this.parsePolicies(aim, krbAis, kerberosToken);
            this.assertPolicy(aim, "RequireKeyIdentifierReference");
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, KerberosSecurity kerberosToken) {
        for (AssertionInfo ai : ais) {
            KerberosToken kerberosTokenPolicy = (KerberosToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired((AbstractToken)kerberosTokenPolicy, this.message)) {
                this.assertPolicy(aim, new QName(kerberosTokenPolicy.getVersion().getNamespace(), "WssKerberosV5ApReqToken11"));
                this.assertPolicy(aim, new QName(kerberosTokenPolicy.getVersion().getNamespace(), "WssGssKerberosV5ApReqToken11"));
                continue;
            }
            if (this.checkToken(aim, kerberosTokenPolicy, kerberosToken)) continue;
            ai.setNotAsserted("An incorrect Kerberos Token Type is detected");
        }
    }

    private boolean checkToken(AssertionInfoMap aim, KerberosToken kerberosTokenPolicy, KerberosSecurity kerberosToken) {
        KerberosToken.ApReqTokenType apReqTokenType = kerberosTokenPolicy.getApReqTokenType();
        if (apReqTokenType == KerberosToken.ApReqTokenType.WssKerberosV5ApReqToken11 && kerberosToken.isV5ApReq()) {
            this.assertPolicy(aim, new QName(kerberosTokenPolicy.getVersion().getNamespace(), "WssKerberosV5ApReqToken11"));
            return true;
        }
        if (apReqTokenType == KerberosToken.ApReqTokenType.WssGssKerberosV5ApReqToken11 && kerberosToken.isGssV5ApReq()) {
            this.assertPolicy(aim, new QName(kerberosTokenPolicy.getVersion().getNamespace(), "WssGssKerberosV5ApReqToken11"));
            return true;
        }
        return false;
    }
}

