/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class XLogAuditFilter
extends XLogFilter {
    public XLogAuditFilter(XLogUserFilterParam xLogUserFilterParam) {
        super(xLogUserFilterParam);
    }

    @Override
    public void calculateAndValidateDateRange(Date jobStartTime, Date jobEndTime) throws IOException {
        if (jobStartTime == null || jobEndTime == null) {
            return;
        }
        if (jobStartTime.after(jobEndTime)) {
            throw new IOException("Start time should be less than end time. startTime = " + jobStartTime + " endtime = " + jobEndTime);
        }
    }

    @Override
    public void constructPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("(.* ");
        sb.append("JOBID \\[");
        sb.append(this.getFilterParams().get("JOB") + "\\]");
        sb.append(".*)");
        this.setFilterPattern(Pattern.compile(sb.toString()));
    }
}

