/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XConfiguration;

public class JobUtils {
    public static void normalizeAppPath(String user, String group, Configuration conf) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        if (conf.get("oozie.proxysubmission") != null) {
            return;
        }
        String wfPathStr = conf.get("oozie.wf.application.path");
        String coordPathStr = conf.get("oozie.coord.application.path");
        String bundlePathStr = conf.get("oozie.bundle.application.path");
        String appPathStr = wfPathStr != null ? wfPathStr : (coordPathStr != null ? coordPathStr : bundlePathStr);
        FileSystem fs = null;
        try {
            URI uri = new Path(appPathStr).toUri();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            fs = has.createFileSystem(user, uri, (Configuration)fsConf);
        }
        catch (HadoopAccessorException ex) {
            throw new IOException(ex.getMessage());
        }
        Path appPath = new Path(appPathStr);
        String normalizedAppPathStr = appPathStr;
        if (!fs.exists(appPath)) {
            throw new IOException("Error: " + appPathStr + " does not exist");
        }
        if (wfPathStr != null) {
            conf.set("oozie.wf.application.path", normalizedAppPathStr);
        } else if (coordPathStr != null) {
            conf.set("oozie.coord.application.path", normalizedAppPathStr);
        } else if (bundlePathStr != null) {
            conf.set("oozie.bundle.application.path", normalizedAppPathStr);
        }
    }

    public static Map<String, String> parseChangeValue(String changeValue) throws CommandException {
        String[] tokens;
        if (changeValue == null || changeValue.trim().equalsIgnoreCase("")) {
            throw new CommandException(ErrorCode.E1015, "change value can not be empty string or null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String token : tokens = changeValue.split(";")) {
            if (!token.contains("=")) {
                throw new CommandException(ErrorCode.E1015, changeValue, "change value must be name=value pair or name=(empty string)");
            }
            String[] pair = token.split("=");
            String key = pair[0];
            if (map.containsKey(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "can not specify repeated change values on " + key);
            }
            if (pair.length == 2) {
                map.put(key, pair[1]);
                continue;
            }
            if (pair.length == 1) {
                map.put(key, "");
                continue;
            }
            throw new CommandException(ErrorCode.E1015, changeValue, "elements on " + key + " must be name=value pair or name=(empty string)");
        }
        return map;
    }

    public static void addFileToClassPath(Path file, Configuration conf, FileSystem fs) throws IOException {
        if (fs == null) {
            JobConf defaultConf = Services.get().get(HadoopAccessorService.class).createJobConf(conf.get("mapred.job.tracker"));
            XConfiguration.copy(conf, (Configuration)defaultConf);
            fs = file.getFileSystem((Configuration)defaultConf);
        }
        if (Services.get().get(HadoopAccessorService.class).getCachedConf().get("yarn.resourcemanager.webapp.address") == null) {
            String filepath = file.toUri().getPath();
            String classpath = conf.get("mapred.job.classpath.files");
            conf.set("mapred.job.classpath.files", classpath == null ? filepath : classpath + System.getProperty("path.separator") + filepath);
            URI uri = fs.makeQualified(file).toUri();
            DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
        } else {
            DistributedCache.addFileToClassPath((Path)file, (Configuration)conf, (FileSystem)fs);
        }
    }
}

