/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceUnit;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StoreService;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

@PersistenceUnit(unitName="oozie")
public abstract class Store {
    private EntityManager entityManager;

    public Store() {
        this.entityManager = Services.get().get(StoreService.class).getEntityManager();
    }

    public Store(Store store) {
        this.entityManager = store.getEntityManager();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void beginTrx() {
        this.entityManager.setFlushMode(FlushModeType.COMMIT);
        this.entityManager.getTransaction().begin();
    }

    public void commitTrx() {
        this.entityManager.getTransaction().commit();
    }

    public void closeTrx() {
        this.entityManager.close();
    }

    public void rollbackTrx() {
        this.entityManager.getTransaction().rollback();
    }

    public boolean isActive() {
        return this.entityManager.getTransaction().isActive();
    }

    public String getConnection() {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.entityManager);
        Connection conn = (Connection)kem.getConnection();
        return conn.toString();
    }

    public boolean isDetached(Object o) {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.entityManager);
        return kem.isDetached(o);
    }

    public boolean isClosed() {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.entityManager);
        Connection conn = (Connection)kem.getConnection();
        try {
            return conn.isClosed();
        }
        catch (SQLException e) {
            XLog.getLog(this.getClass()).info(1, e.getMessage(), e);
            return true;
        }
    }

    public boolean contains(Object entity) {
        return this.entityManager.contains(entity);
    }

    public String getFlushMode() {
        return this.entityManager.getFlushMode().toString();
    }
}

