/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonSLAEvent;
import org.apache.oozie.compression.CodecFactory;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;

public class JPAService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP_JPA = "jpa";
    public static final String CONF_DB_SCHEMA = "oozie.db.schema.name";
    public static final String CONF_PREFIX = "oozie.service.JPAService.";
    public static final String CONF_URL = "oozie.service.JPAService.jdbc.url";
    public static final String CONF_DRIVER = "oozie.service.JPAService.jdbc.driver";
    public static final String CONF_USERNAME = "oozie.service.JPAService.jdbc.username";
    public static final String CONF_PASSWORD = "oozie.service.JPAService.jdbc.password";
    public static final String CONF_CONN_DATA_SOURCE = "oozie.service.JPAService.connection.data.source";
    public static final String CONF_CONN_PROPERTIES = "oozie.service.JPAService.connection.properties";
    public static final String CONF_MAX_ACTIVE_CONN = "oozie.service.JPAService.pool.max.active.conn";
    public static final String CONF_CREATE_DB_SCHEMA = "oozie.service.JPAService.create.db.schema";
    public static final String CONF_VALIDATE_DB_CONN = "oozie.service.JPAService.validate.db.connection";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL = "oozie.service.JPAService.validate.db.connection.eviction.interval";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_NUM = "oozie.service.JPAService.validate.db.connection.eviction.num";
    public static final String CONF_OPENJPA_BROKER_IMPL = "oozie.service.JPAService.openjpa.BrokerImpl";
    private EntityManagerFactory factory;
    private Instrumentation instr;
    private static XLog LOG;

    @Override
    public Class<? extends Service> getInterface() {
        return JPAService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        this.instr = instr;
        final BasicDataSource dataSource = this.getBasicDataSource();
        if (dataSource != null) {
            instr.addSampler("jdbc", "connections.active", 60, 1, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return dataSource.getNumActive();
                }
            });
            instr.addSampler("jdbc", "connections.idle", 60, 1, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return dataSource.getNumIdle();
                }
            });
        }
    }

    private BasicDataSource getBasicDataSource() {
        BasicDataSource basicDataSource = null;
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.factory;
        Object connectionFactory = spi.getConfiguration().getConnectionFactory();
        if (connectionFactory instanceof DecoratingDataSource) {
            DecoratingDataSource decoratingDataSource = (DecoratingDataSource)connectionFactory;
            basicDataSource = (BasicDataSource)decoratingDataSource.getInnermostDelegate();
        } else if (connectionFactory instanceof BasicDataSource) {
            basicDataSource = (BasicDataSource)connectionFactory;
        }
        return basicDataSource;
    }

    @Override
    public void init(Services services) throws ServiceException {
        LOG = XLog.getLog(JPAService.class);
        Configuration conf = services.getConf();
        String dbSchema = ConfigurationService.get(conf, CONF_DB_SCHEMA);
        String url = ConfigurationService.get(conf, CONF_URL);
        String driver = ConfigurationService.get(conf, CONF_DRIVER);
        String user = ConfigurationService.get(conf, CONF_USERNAME);
        String password = ConfigurationService.getPassword(conf, CONF_PASSWORD).trim();
        String maxConn = ConfigurationService.get(conf, CONF_MAX_ACTIVE_CONN).trim();
        String dataSource = ConfigurationService.get(conf, CONF_CONN_DATA_SOURCE);
        String connPropsConfig = ConfigurationService.get(conf, CONF_CONN_PROPERTIES);
        String brokerImplConfig = ConfigurationService.get(conf, CONF_OPENJPA_BROKER_IMPL);
        boolean autoSchemaCreation = ConfigurationService.getBoolean(conf, CONF_CREATE_DB_SCHEMA);
        boolean validateDbConn = ConfigurationService.getBoolean(conf, CONF_VALIDATE_DB_CONN);
        String evictionInterval = ConfigurationService.get(conf, CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL).trim();
        String evictionNum = ConfigurationService.get(conf, CONF_VALIDATE_DB_CONN_EVICTION_NUM).trim();
        if (!url.startsWith("jdbc:")) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, must start with 'jdbc:'");
        }
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        String persistentUnit = "oozie-" + dbType;
        String ormFile = "META-INF/" + persistentUnit + "-orm.xml";
        try {
            IOUtils.getResourceAsStream(ormFile, -1);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0609, dbType, ormFile);
        }
        if (url.startsWith("jdbc:mysql:replication")) {
            url = "\"".concat(url).concat("\"");
            LOG.info("A jdbc replication url is provided. Url: [{0}]", url);
        }
        String connProps = "DriverClassName={0},Url={1},Username={2},Password={3},MaxActive={4}";
        connProps = MessageFormat.format(connProps, driver, url, user, password, maxConn);
        Properties props = new Properties();
        if (autoSchemaCreation) {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
            props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        } else if (validateDbConn) {
            String interval = "timeBetweenEvictionRunsMillis=" + evictionInterval;
            String num = "numTestsPerEvictionRun=" + evictionNum;
            connProps = connProps + ",TestOnBorrow=true,TestOnReturn=true,TestWhileIdle=true," + interval + "," + num;
            connProps = connProps + ",ValidationQuery=select count(*) from VALIDATE_CONN";
            connProps = MessageFormat.format(connProps, dbSchema);
        } else {
            connProps = connProps + ",TestOnBorrow=true,TestOnReturn=true,TestWhileIdle=false";
        }
        if (connPropsConfig != null) {
            connProps = connProps + "," + connPropsConfig;
        }
        props.setProperty("openjpa.ConnectionProperties", connProps);
        props.setProperty("openjpa.ConnectionDriverName", dataSource);
        if (!StringUtils.isEmpty((String)brokerImplConfig)) {
            props.setProperty("openjpa.BrokerImpl", brokerImplConfig);
            LOG.info("Setting openjpa.BrokerImpl to {0}", brokerImplConfig);
        }
        this.factory = Persistence.createEntityManagerFactory((String)persistentUnit, (Map)props);
        EntityManager entityManager = this.getEntityManager();
        entityManager.find(WorkflowActionBean.class, (Object)1);
        entityManager.find(WorkflowJobBean.class, (Object)1);
        entityManager.find(CoordinatorActionBean.class, (Object)1);
        entityManager.find(CoordinatorJobBean.class, (Object)1);
        entityManager.find(SLAEventBean.class, (Object)1);
        entityManager.find(JsonSLAEvent.class, (Object)1);
        entityManager.find(BundleJobBean.class, (Object)1);
        entityManager.find(BundleActionBean.class, (Object)1);
        entityManager.find(SLARegistrationBean.class, (Object)1);
        entityManager.find(SLASummaryBean.class, (Object)1);
        LOG.info(1, "All entities initialized", new Object[0]);
        entityManager.getTransaction().begin();
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.factory;
        String logMsg = spi.getConfiguration().getConnectionProperties().replaceAll("Password=.*?,", "Password=***,");
        LOG.info("JPA configuration: {0}", logMsg);
        entityManager.getTransaction().commit();
        entityManager.close();
        try {
            CodecFactory.initialize(conf);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), ex);
        }
    }

    @Override
    public void destroy() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(JPAExecutor<T> executor) throws JPAExecutorException {
        T t;
        EntityManager em = this.getEntityManager();
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing JPAExecutor [{0}]", executor.getName());
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, executor.getName(), 1L);
            }
            cron.start();
            em.getTransaction().begin();
            T t2 = executor.execute(em);
            if (em.getTransaction().isActive()) {
                if (FaultInjection.isActive("org.apache.oozie.command.SkipCommitFaultInjection")) {
                    throw new RuntimeException("Skipping Commit for Failover Testing");
                }
                em.getTransaction().commit();
            }
            t = t2;
            cron.stop();
            if (this.instr != null) {
                this.instr.addCron(INSTRUMENTATION_GROUP_JPA, executor.getName(), cron);
            }
        }
        catch (PersistenceException e) {
            try {
                throw new JPAExecutorException(ErrorCode.E0603, new Object[]{e});
            }
            catch (Throwable throwable) {
                cron.stop();
                if (this.instr != null) {
                    this.instr.addCron(INSTRUMENTATION_GROUP_JPA, executor.getName(), cron);
                }
                try {
                    if (em.getTransaction().isActive()) {
                        LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                        em.getTransaction().rollback();
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                try {
                    if (em.isOpen()) {
                        em.close();
                        throw throwable;
                    }
                    LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                throw throwable;
            }
        }
        try {
            if (em.getTransaction().isActive()) {
                LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                em.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        try {
            if (em.isOpen()) {
                em.close();
                return t;
            }
            LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
            return t;
        }
        catch (Exception ex) {
            LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        return t;
    }

    public int executeUpdate(String namedQueryName, Query query, EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Update/Delete Query [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            em.getTransaction().begin();
            int ret = query.executeUpdate();
            if (em.getTransaction().isActive()) {
                if (FaultInjection.isActive("org.apache.oozie.command.SkipCommitFaultInjection")) {
                    throw new RuntimeException("Skipping Commit for Failover Testing");
                }
                em.getTransaction().commit();
            }
            int n = ret;
            return n;
        }
        catch (PersistenceException e) {
            throw new JPAExecutorException(ErrorCode.E0603, new Object[]{e});
        }
        finally {
            this.processFinally(em, cron, namedQueryName, true);
        }
    }

    private void processFinally(EntityManager em, Instrumentation.Cron cron, String name, boolean checkActive) {
        cron.stop();
        if (this.instr != null) {
            this.instr.addCron(INSTRUMENTATION_GROUP_JPA, name, cron);
        }
        if (checkActive) {
            try {
                if (em.getTransaction().isActive()) {
                    LOG.warn("[{0}] ended with an active transaction, rolling back", name);
                    em.getTransaction().rollback();
                }
            }
            catch (Exception ex) {
                LOG.warn("Could not check/rollback transaction after [{0}], {1}", name, ex.getMessage(), ex);
            }
        }
        try {
            if (em.isOpen()) {
                em.close();
            } else {
                LOG.warn("[{0}] closed the EntityManager, it should not!", name);
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not close EntityManager after [{0}], {1}", name, ex.getMessage(), ex);
        }
    }

    public void executeBatchInsertUpdateDelete(Collection<JsonBean> insertBeans, List<QueryEntry> updateQueryList, Collection<JsonBean> deleteBeans, EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Queries in Batch");
            cron.start();
            em.getTransaction().begin();
            if (updateQueryList != null && updateQueryList.size() > 0) {
                for (QueryEntry q : updateQueryList) {
                    if (this.instr != null) {
                        this.instr.incr(INSTRUMENTATION_GROUP_JPA, ((Enum)q.getQueryName()).name(), 1L);
                    }
                    q.getQuery().executeUpdate();
                }
            }
            if (insertBeans != null && insertBeans.size() > 0) {
                for (JsonBean bean : insertBeans) {
                    em.persist((Object)bean);
                }
            }
            if (deleteBeans != null && deleteBeans.size() > 0) {
                for (JsonBean bean : deleteBeans) {
                    em.remove(em.merge((Object)bean));
                }
            }
            if (em.getTransaction().isActive()) {
                if (FaultInjection.isActive("org.apache.oozie.command.SkipCommitFaultInjection")) {
                    throw new RuntimeException("Skipping Commit for Failover Testing");
                }
                em.getTransaction().commit();
            }
        }
        catch (PersistenceException e) {
            throw new JPAExecutorException(ErrorCode.E0603, new Object[]{e});
        }
        finally {
            this.processFinally(em, cron, "batchqueryexecutor", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeGet(String namedQueryName, Query query, EntityManager em) {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Select Query to Get a Single row  [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            Object obj = null;
            try {
                obj = query.getSingleResult();
            }
            catch (NoResultException e) {
                // empty catch block
            }
            Object object = obj;
            return object;
        }
        finally {
            this.processFinally(em, cron, namedQueryName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> executeGetList(String namedQueryName, Query query, EntityManager em) {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Select Query to Get Multiple Rows [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            List resultList = null;
            try {
                resultList = query.getResultList();
            }
            catch (NoResultException e) {
                // empty catch block
            }
            List list = resultList;
            return list;
        }
        finally {
            this.processFinally(em, cron, namedQueryName, false);
        }
    }

    public EntityManager getEntityManager() {
        return this.factory.createEntityManager();
    }

    public static class QueryEntry<E extends Enum<E>> {
        E namedQuery;
        Query query;

        public QueryEntry(E namedQuery, Query query) {
            this.namedQuery = namedQuery;
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }

        public E getQueryName() {
            return this.namedQuery;
        }
    }
}

