/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class SupplementalPlugin
extends Plugin
implements ClassLoadingPluginInterface {
    Map<Class, Callable> factoryMap = new HashMap<Class, Callable>();
    private Class<? extends PluginTypeInterface> pluginClass;
    private String id;

    public SupplementalPlugin(Class<? extends PluginTypeInterface> pluginClass, String id) {
        super(new String[]{id}, pluginClass, null, "", id, id, "", false, false, Collections.emptyMap(), Collections.emptyList(), "", null);
        this.pluginClass = pluginClass;
        this.id = id;
    }

    @Override
    public <T> T loadClass(Class<T> pluginClass) {
        if (!this.factoryMap.containsKey(pluginClass)) {
            return null;
        }
        try {
            return (T)this.factoryMap.get(pluginClass).call();
        }
        catch (Exception e) {
            throw new RuntimeException(new KettlePluginException("Error creating plugin class", e));
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public <T> void addFactory(Class<T> tClass, Callable<T> callable) {
        this.factoryMap.put(tClass, callable);
    }
}

