/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.build;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.JobEntryDialogBoilerplate;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.util.TransUtil;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.entries.build.SelectModelDialog;

public class JobEntryBuildModelDialog
extends JobEntryDialogBoilerplate<JobEntryBuildModel>
implements JobEntryDialogInterface {
    private ComboVar wOutputStep;
    private Label wlOutputStep;
    private TextVar wModelName;
    private Label wlModelName;
    private Button wUseAutoModel;
    private Button wUseExistingModel;
    private Group gModelGroup;
    private Text wExistingModelName;
    private Label wlExistingModelExtra;
    private Button wSelectExistingModel;
    private Composite wExistingModel;
    private SelectModelDialog selectModelDialog;
    private JobEntryBuildModel jobEntry;

    public JobEntryBuildModelDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) throws KettleException {
        super(parent, jobEntry, rep, jobMeta);
        this.jobEntry = (JobEntryBuildModel)jobEntry;
        this.jobEntry.setRepository(jobMeta.getRepository());
        TransUtil.resetParams((AbstractMeta)jobMeta, jobEntry.getLogChannel());
        this.PKG = JobEntryBuildModel.class;
    }

    @Override
    protected String getTitle() {
        return this.getMsg("BuildModelJob.Name");
    }

    @Override
    protected void createControls(Shell shell, Control topControl, Control bottomControl, Composite main) {
        String[] stringArray;
        FormLayout layout = new FormLayout();
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite widgetAbove = main;
        this.wOutputStep = new ComboVar((VariableSpace)this.jobMeta, main, 18432);
        String[] stepNames = this.jobEntry.getOutputStepList(this.jobMeta);
        if (stepNames.length > 0) {
            stringArray = stepNames;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        this.wOutputStep.setItems(stringArray);
        this.wOutputStep.setToolTipText(this.getMsg("BuildModelJob.OutputStep.Description"));
        this.wOutputStep.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                JobEntryBuildModelDialog.this.wOutputStep.getCComboWidget().setSelection(new Point(0, 0));
            }
        });
        this.wlOutputStep = new Label(main, 131072);
        this.wlOutputStep.setText(this.getMsg("BuildModelJob.OutputStep.Label"));
        widgetAbove = this.addLabelInputPairBelow((Control)this.wlOutputStep, (Control)this.wOutputStep, (Control)widgetAbove, 250 + VAR_EXTRA_WIDTH);
        this.wModelName = new TextVar((VariableSpace)this.jobMeta, main, 18436);
        this.wModelName.setToolTipText(this.getMsg("BuildModelJob.ModelName.Description"));
        this.wlModelName = new Label(main, 131072);
        this.wlModelName.setText(this.getMsg("BuildModelJob.ModelName.Label"));
        widgetAbove = this.addLabelInputPairBelow((Control)this.wlModelName, (Control)this.wModelName, (Control)widgetAbove, 250 + VAR_EXTRA_WIDTH);
        this.addModelGroup(main, (Control)widgetAbove);
        int minHeight = this.getMinHeight((Composite)shell);
        shell.setMinimumSize(435, minHeight);
        shell.setSize(435, minHeight);
    }

    private Group addModelGroup(Composite parent, Control widgetAbove) {
        this.gModelGroup = this.createGroup(parent, widgetAbove, this.getMsg("BuildModelJob.ModelingMethod"));
        widgetAbove = this.gModelGroup;
        this.wUseAutoModel = new Button((Composite)this.gModelGroup, 16);
        this.wUseAutoModel.setText(this.getMsg("BuildModelJob.AutoModel"));
        this.wUseAutoModel.setSelection(true);
        this.wUseAutoModel.addSelectionListener(this.modelMethodSelectionListener(false));
        widgetAbove = this.addControlBelow((Control)this.wUseAutoModel, widgetAbove);
        ((FormData)this.wUseAutoModel.getLayoutData()).left = new FormAttachment(0, 1);
        this.wUseExistingModel = new Button((Composite)this.gModelGroup, 16);
        this.wUseExistingModel.setText(this.getMsg("BuildModelJob.UseExistingModel"));
        this.wUseExistingModel.addSelectionListener(this.modelMethodSelectionListener(true));
        widgetAbove = this.addControlBelow((Control)this.wUseExistingModel, widgetAbove);
        ((FormData)this.wUseExistingModel.getLayoutData()).left = new FormAttachment(0, 1);
        widgetAbove = this.addExistingModelControl((Composite)this.gModelGroup, widgetAbove);
        return this.gModelGroup;
    }

    private Control addExistingModelControl(Composite parent, Control widgetAbove) {
        this.wExistingModel = new ExistingModelControl(parent, 0);
        this.wExistingModel.setLayout((Layout)new FormLayout());
        this.wSelectExistingModel = new Button(this.wExistingModel, 524288);
        this.wSelectExistingModel.setText(this.getMsg("BuildModelJob.SelectExistingModel"));
        this.props.setLook((Control)this.wSelectExistingModel);
        FormData fdSelectExisting = new FormData(65, -1);
        fdSelectExisting.right = new FormAttachment(100);
        this.wSelectExistingModel.setLayoutData((Object)fdSelectExisting);
        this.wSelectExistingModel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JobEntryBuildModelDialog.this.selectModelDialog = new SelectModelDialog(JobEntryBuildModelDialog.this.shell, JobEntryBuildModelDialog.this.jobEntry, JobEntryBuildModelDialog.this.rep, JobEntryBuildModelDialog.this.jobMeta){

                    @Override
                    protected String getJobIcon() {
                        return null;
                    }

                    @Override
                    protected void ok() {
                        super.ok();
                        JobEntryBuildModelDialog.this.updateExistingModel((JobEntryBuildModel)this.jobEntry);
                    }
                };
                JobEntryBuildModelDialog.this.selectModelDialog.open();
            }
        });
        this.wExistingModelName = new Text(this.wExistingModel, 18436);
        this.props.setLook((Control)this.wExistingModelName);
        int leftIndent = 18;
        FormData fdExistingModelName = new FormData(250, -1);
        fdExistingModelName.top = new FormAttachment((Control)this.wUseExistingModel);
        fdExistingModelName.left = new FormAttachment(0, 18);
        fdExistingModelName.right = new FormAttachment((Control)this.wSelectExistingModel, -5);
        this.wExistingModelName.setLayoutData((Object)fdExistingModelName);
        this.wExistingModelName.setEditable(false);
        this.wlExistingModelExtra = new Label(this.wExistingModel, 16448);
        FormData fdExistingModelExtra = new FormData();
        fdExistingModelExtra.top = new FormAttachment((Control)this.wExistingModelName, 5);
        fdExistingModelExtra.left = new FormAttachment(0, 18);
        fdExistingModelExtra.bottom = new FormAttachment(100);
        fdExistingModelExtra.right = new FormAttachment(100);
        fdExistingModelExtra.height = 35;
        this.wlExistingModelExtra.setLayoutData((Object)fdExistingModelExtra);
        this.wlExistingModelExtra.setEnabled(false);
        this.props.setLook((Control)this.wlExistingModelExtra);
        this.wSelectExistingModel.pack();
        int width = 273 + Math.max(65, this.wSelectExistingModel.getSize().x) + 20;
        return this.addControlBelow((Control)this.wExistingModel, widgetAbove, width);
    }

    private void updateExistingModel(JobEntryBuildModel jobEntry) {
        String selectedModel = StringUtils.defaultString((String)jobEntry.getSelectedModel(), (String)"");
        this.wExistingModelName.setText(selectedModel);
        if (StringUtils.isBlank((String)selectedModel)) {
            this.wlExistingModelExtra.setText(this.getMsg("BuildModelJob.SelectedModelInfo.NotSelected"));
        } else if (jobEntry.isCreateOnPublish()) {
            this.wlExistingModelExtra.setText(this.getMsg("BuildModelJob.SelectedModelInfo.CreateOnPublish"));
        } else {
            this.wlExistingModelExtra.setText(this.getMsg("BuildModelJob.SelectedModelInfo.NotCreateOnPublish"));
        }
    }

    private SelectionListener modelMethodSelectionListener(final boolean enabled) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JobEntryBuildModelDialog.this.wExistingModel.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
    }

    @Override
    protected void loadData(JobEntryBuildModel jobEntry) {
        super.loadData(jobEntry);
        if (jobEntry.getOutputStep() != null) {
            this.wOutputStep.setText(jobEntry.getOutputStep());
            this.wOutputStep.getCComboWidget().setSelection(new Point(0, 0));
        }
        if (jobEntry.getModelName() != null) {
            this.wModelName.setText(jobEntry.getModelName());
        }
        this.wUseExistingModel.setSelection(jobEntry.useExistingModel());
        this.wUseAutoModel.setSelection(!jobEntry.useExistingModel());
        this.wExistingModel.setEnabled(jobEntry.useExistingModel());
        this.updateExistingModel(jobEntry);
    }

    @Override
    protected void saveData(JobEntryBuildModel jobEntry) {
        super.saveData(jobEntry);
        jobEntry.setOutputStep(this.wOutputStep.getText());
        jobEntry.setModelName(this.wModelName.getText());
        jobEntry.setUseExistingModel(this.wUseExistingModel.getSelection());
        jobEntry.setExistingModel(this.wExistingModelName.getText());
    }

    @Override
    protected String getJobIcon() {
        return "model_entry.svg";
    }

    @Override
    protected boolean okToClose() {
        if (super.okToClose()) {
            if (StringUtils.containsAny((String)this.wModelName.getText(), (String)"/\\\t\r\n")) {
                this.showError(this.getMsg("System.StepJobEntryNameMissing.Title"), this.getMsg("BuildModelJob.Error.ModelName.InvalidCharacter"));
                return false;
            }
            return true;
        }
        return false;
    }

    private class ExistingModelControl
    extends Composite {
        public ExistingModelControl(Composite parent, int flags) {
            super(parent, flags);
        }

        public void setEnabled(boolean enabled) {
            JobEntryBuildModelDialog.this.wSelectExistingModel.setEnabled(enabled);
            JobEntryBuildModelDialog.this.wExistingModelName.setEnabled(enabled);
            JobEntryBuildModelDialog.this.wlExistingModelExtra.setEnabled(enabled);
            if (enabled) {
                JobEntryBuildModelDialog.this.wlExistingModelExtra.setForeground(null);
            } else {
                JobEntryBuildModelDialog.this.wlExistingModelExtra.setForeground(this.getDisplay().getSystemColor(15));
            }
        }
    }
}

