/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileUploader {
    public static final Log LOG = LogFactory.getLog((String)FileUploader.class.getName());

    private FileUploader() {
    }

    public static void uploadFilesToDFS(String srcBasePath, String src, String destBasePath, String dest, Configuration conf) throws IOException {
        Path targetPath;
        FileSystem fs;
        Path srcPath = new Path(srcBasePath, src);
        if (destBasePath == null || destBasePath.isEmpty()) {
            destBasePath = ".";
        }
        if (!(fs = (targetPath = new Path(destBasePath, dest)).getFileSystem(conf)).exists(targetPath)) {
            fs.mkdirs(targetPath);
        }
        Path targetPath2 = new Path(targetPath, src);
        fs.delete(targetPath2, true);
        try {
            LOG.info((Object)("Copying " + srcPath + " to " + targetPath));
            fs.copyFromLocalFile(false, true, srcPath, targetPath);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to copy " + srcPath + " to " + targetPath));
        }
    }
}

