/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class RandomTypeUtil {
    public static final long NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    public static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    public static final long NANOSECONDS_PER_MILLISSECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static int MIN_YEAR = 1900;
    public static int MAX_YEAR = 3000;
    private static long MIN_FOUR_DIGIT_YEAR_MILLIS = RandomTypeUtil.parseToMillis("1900-01-01 00:00:00");
    private static long MAX_FOUR_DIGIT_YEAR_MILLIS = RandomTypeUtil.parseToMillis("3000-01-01 00:00:00");

    private static long parseToMillis(String s) {
        try {
            return DATE_FORMAT.get().parse(s).getTime();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Timestamp getRandTimestamp(Random r) {
        return RandomTypeUtil.getRandTimestamp(r, MIN_YEAR, MAX_YEAR);
    }

    public static Timestamp getRandTimestamp(Random r, int minYear, int maxYear) {
        Timestamp timestampVal;
        String optionalNanos = "";
        switch (r.nextInt(4)) {
            case 0: {
                break;
            }
            case 1: {
                optionalNanos = String.format(".%09d", r.nextInt((int)NANOSECONDS_PER_SECOND));
                break;
            }
            case 2: {
                optionalNanos = String.format(".%09d", (long)Integer.valueOf(r.nextInt((int)MILLISECONDS_PER_SECOND)).intValue() * NANOSECONDS_PER_MILLISSECOND);
                break;
            }
            case 3: {
                optionalNanos = String.format(".%09d", r.nextInt((int)NANOSECONDS_PER_MILLISSECOND));
            }
        }
        String timestampStr = String.format("%04d-%02d-%02d %02d:%02d:%02d%s", minYear + r.nextInt(maxYear - minYear + 1), 1 + r.nextInt(12), 1 + r.nextInt(28), 0 + r.nextInt(24), 0 + r.nextInt(60), 0 + r.nextInt(60), optionalNanos);
        try {
            timestampVal = Timestamp.valueOf(timestampStr);
        }
        catch (Exception e) {
            System.err.println("Timestamp string " + timestampStr + " did not parse");
            throw e;
        }
        return timestampVal;
    }

    public static long randomMillis(long minMillis, long maxMillis, Random rand) {
        return minMillis + (long)((double)(maxMillis - minMillis) * rand.nextDouble());
    }

    public static long randomMillis(Random rand) {
        return RandomTypeUtil.randomMillis(MIN_FOUR_DIGIT_YEAR_MILLIS, MAX_FOUR_DIGIT_YEAR_MILLIS, rand);
    }

    public static int randomNanos(Random rand, int decimalDigits) {
        int nanos = rand.nextInt((int)NANOSECONDS_PER_SECOND);
        return nanos - nanos % (int)Math.pow(10.0, 9 - decimalDigits);
    }

    public static int randomNanos(Random rand) {
        return RandomTypeUtil.randomNanos(rand, 9);
    }
}

