/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public final class ImmutableDataAttributes
implements DataAttributes {
    public static final ImmutableDataAttributes EMPTY = new ImmutableDataAttributes();
    private AttributeMap<Entry> backend = new AttributeMap();

    private ImmutableDataAttributes() {
    }

    private ImmutableDataAttributes(DataAttributes source, DataAttributeContext context) {
        this.merge(source, context);
    }

    public ImmutableDataAttributes(AttributeMap<Object> data) {
        for (AttributeMap.DualKey k : data.keySet()) {
            Object value = data.getAttribute(k.namespace, k.name);
            this.backend.setAttribute(k.namespace, k.name, (Object)new Entry(DefaultConceptQueryMapper.INSTANCE, value));
        }
    }

    public static ImmutableDataAttributes create(DataAttributes source, DataAttributeContext context) {
        if (source instanceof ImmutableDataAttributes) {
            return (ImmutableDataAttributes)source;
        }
        return new ImmutableDataAttributes(source, context);
    }

    @Override
    public String[] getMetaAttributeDomains() {
        return this.backend.getNameSpaces();
    }

    @Override
    public String[] getMetaAttributeNames(String domainName) {
        if (domainName == null) {
            throw new NullPointerException();
        }
        return this.backend.getNames(domainName);
    }

    @Override
    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    @Override
    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Entry attribute = (Entry)this.backend.getAttribute(domain, name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.value == null) {
            return defaultValue;
        }
        ConceptQueryMapper mapper = attribute.mapper;
        return mapper.getValue(attribute.value, type, context);
    }

    @Override
    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        Entry attribute = (Entry)this.backend.getAttribute(domain, name);
        if (attribute == null) {
            return DefaultConceptQueryMapper.INSTANCE;
        }
        return attribute.mapper;
    }

    private void merge(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String[] domains = attributes.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = attributes.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = attributes.getMetaAttribute(domain, name, null, context);
                if (value == null) continue;
                ConceptQueryMapper mapper = attributes.getMetaAttributeMapper(domain, name);
                this.backend.setAttribute(domain, name, (Object)new Entry(mapper, value));
            }
        }
    }

    @Override
    public ImmutableDataAttributes clone() throws CloneNotSupportedException {
        ImmutableDataAttributes o = (ImmutableDataAttributes)super.clone();
        o.backend = this.backend.clone();
        return o;
    }

    public boolean isEmpty() {
        return this.backend.getNameSpaces().length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDataAttributes that = (ImmutableDataAttributes)o;
        return this.backend.equals(that.backend);
    }

    public int hashCode() {
        return this.backend.hashCode();
    }

    private static class Entry
    implements Serializable {
        public final ConceptQueryMapper mapper;
        public final Object value;

        private Entry(ConceptQueryMapper mapper, Object value) {
            this.mapper = mapper;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.mapper != null ? !this.mapper.equals(entry.mapper) : entry.mapper != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(entry.value) : entry.value != null);
        }

        public int hashCode() {
            int result = this.mapper != null ? this.mapper.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

