/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.HashSet;
import java.util.LinkedHashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabNormalizationMode;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.OrderedMergeCrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.SortedMergeCrosstabSpecification;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class CrosstabProcessorFunction
extends AbstractFunction
implements StructureFunction {
    private FastStack<CrosstabSpecification> processingStack;
    private CrosstabSpecification result;

    @Override
    public int getProcessingPriority() {
        return Short.MIN_VALUE;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        ReportState state = event.getState();
        if (event.getLevel() == this.getDependencyLevel()) {
            Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
            if (group instanceof CrosstabGroup) {
                CrosstabGroup crosstabGroup = (CrosstabGroup)group;
                if (this.processingStack == null) {
                    this.processingStack = new FastStack();
                }
                String[] columnSet = this.computeColumns(crosstabGroup);
                String[] rowSet = this.computeRows(crosstabGroup);
                ReportStateKey processKey = state.getProcessKey();
                CrosstabNormalizationMode normalizationMode = (CrosstabNormalizationMode)((Object)group.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "normalization-mode"));
                if (CrosstabNormalizationMode.Insertation.equals((Object)normalizationMode)) {
                    this.processingStack.push((Object)new OrderedMergeCrosstabSpecification(processKey, columnSet, rowSet));
                } else {
                    this.processingStack.push((Object)new SortedMergeCrosstabSpecification(processKey, columnSet, rowSet));
                }
                return;
            }
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            CrosstabSpecification csstate = (CrosstabSpecification)this.processingStack.peek();
            if (csstate == null) {
                return;
            }
            if (group instanceof CrosstabRowGroup && group.getBody() instanceof CrosstabColumnGroupBody) {
                csstate.startRow();
            }
        }
    }

    @Override
    public void groupFinished(ReportEvent event) {
        if (this.processingStack == null || this.processingStack.isEmpty()) {
            return;
        }
        CrosstabSpecification csstate = (CrosstabSpecification)this.processingStack.peek();
        if (csstate == null) {
            return;
        }
        ReportState state = event.getState();
        if (event.getLevel() == this.getDependencyLevel()) {
            Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
            if (group instanceof CrosstabGroup) {
                csstate.endCrosstab();
                this.result = (CrosstabSpecification)this.processingStack.pop();
                return;
            }
            if (group instanceof CrosstabRowGroup && group.getBody() instanceof CrosstabColumnGroupBody) {
                csstate.endRow();
            }
        }
    }

    private String[] computeColumns(CrosstabGroup crosstabGroup) {
        HashSet<String> list = new HashSet<String>();
        GroupBody body = crosstabGroup.getBody();
        while (body != null) {
            Group otherGroup;
            GroupBody cogb;
            if (body instanceof SubGroupBody) {
                SubGroupBody sgBody = (SubGroupBody)body;
                Group g = sgBody.getGroup();
                body = g.getBody();
                continue;
            }
            if (body instanceof CrosstabOtherGroupBody) {
                cogb = (CrosstabOtherGroupBody)body;
                otherGroup = ((CrosstabOtherGroupBody)cogb).getGroup();
                body = otherGroup.getBody();
                continue;
            }
            if (body instanceof CrosstabRowGroupBody) {
                cogb = (CrosstabRowGroupBody)body;
                otherGroup = ((CrosstabRowGroupBody)cogb).getGroup();
                body = otherGroup.getBody();
                continue;
            }
            if (!(body instanceof CrosstabColumnGroupBody)) break;
            cogb = (CrosstabColumnGroupBody)body;
            otherGroup = ((CrosstabColumnGroupBody)cogb).getGroup();
            if (((CrosstabColumnGroup)otherGroup).getField() != null) {
                list.add(((CrosstabColumnGroup)otherGroup).getField());
            }
            body = otherGroup.getBody();
        }
        return list.toArray(new String[list.size()]);
    }

    private String[] computeRows(CrosstabGroup crosstabGroup) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        list.addAll(crosstabGroup.getPaddingFields());
        this.collectRelationalFields(crosstabGroup.getParentSection(), list);
        this.collectCrosstabFields(crosstabGroup, list);
        return list.toArray(new String[list.size()]);
    }

    private void collectRelationalFields(Section section, HashSet<String> list) {
        while (section != null) {
            if (section instanceof AbstractReportDefinition) {
                return;
            }
            if (section instanceof RelationalGroup) {
                RelationalGroup group = (RelationalGroup)section;
                list.addAll(group.getFields());
            }
            section = section.getParentSection();
        }
    }

    private void collectCrosstabFields(CrosstabGroup crosstabGroup, HashSet<String> list) {
        GroupBody body = crosstabGroup.getBody();
        while (body != null) {
            Group otherGroup;
            GroupBody cogb;
            if (body instanceof CrosstabOtherGroupBody) {
                cogb = (CrosstabOtherGroupBody)body;
                otherGroup = ((CrosstabOtherGroupBody)cogb).getGroup();
                if (((CrosstabOtherGroup)otherGroup).getField() != null) {
                    list.add(((CrosstabOtherGroup)otherGroup).getField());
                }
                body = otherGroup.getBody();
                continue;
            }
            if (body instanceof CrosstabRowGroupBody) {
                cogb = (CrosstabRowGroupBody)body;
                otherGroup = ((CrosstabRowGroupBody)cogb).getGroup();
                if (((CrosstabRowGroup)otherGroup).getField() != null) {
                    list.add(((CrosstabRowGroup)otherGroup).getField());
                }
                body = otherGroup.getBody();
                continue;
            }
            if (!(body instanceof CrosstabColumnGroupBody)) break;
            cogb = (CrosstabColumnGroupBody)body;
            otherGroup = ((CrosstabColumnGroupBody)cogb).getGroup();
            body = otherGroup.getBody();
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (event.getLevel() == this.getDependencyLevel()) {
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            CrosstabSpecification state = (CrosstabSpecification)this.processingStack.peek();
            if (state == null) {
                return;
            }
            state.add(this.getDataRow());
        }
    }

    @Override
    public Object getValue() {
        return this.result;
    }

    @Override
    public int getDependencyLevel() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CrosstabProcessorFunction cps = (CrosstabProcessorFunction)super.clone();
        if (this.processingStack == null || this.processingStack.isEmpty()) {
            return cps;
        }
        cps.processingStack = this.processingStack.clone();
        return cps;
    }

    @Override
    public Expression getInstance() {
        CrosstabProcessorFunction cps = (CrosstabProcessorFunction)super.getInstance();
        cps.result = null;
        cps.processingStack = null;
        return cps;
    }
}

