/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionEventHelper;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorageBackend;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class SubLayoutProcess
extends ExpressionEventHelper
implements LayoutProcess {
    private InlineDataRowRuntime inlineDataRowRuntime;
    private StructureFunction[] collectionFunctions;
    private boolean hasPageListener;
    private LayoutProcess parent;
    private LevelStorageBackend[] levelData;
    private InstanceID reportDefinitionId;

    public SubLayoutProcess(LayoutProcess parent, StructureFunction[] structureFunctions, InstanceID reportDefinitionId) {
        if (structureFunctions == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.reportDefinitionId = reportDefinitionId;
        this.parent = parent;
        this.collectionFunctions = (StructureFunction[])structureFunctions.clone();
        this.reinit();
    }

    @Override
    public LayoutProcess getParent() {
        return this.parent;
    }

    private void reinit() {
        this.levelData = LevelStorageBackend.revalidate(this.collectionFunctions, this.collectionFunctions.length, false);
        this.hasPageListener = this.parent.isPageListener();
        for (int i = 0; i < this.levelData.length; ++i) {
            LevelStorageBackend backend = this.levelData[i];
            if (!backend.hasPageEventListeners()) continue;
            this.hasPageListener = true;
        }
    }

    @Override
    public boolean isPageListener() {
        return this.hasPageListener;
    }

    @Override
    public OutputFunction getOutputFunction() {
        return this.parent.getOutputFunction();
    }

    @Override
    public void restart(ReportState state) throws ReportProcessingException {
        this.parent.restart(state);
    }

    @Override
    public StructureFunction[] getCollectionFunctions() {
        return (StructureFunction[])this.collectionFunctions.clone();
    }

    @Override
    protected int getRunLevelCount() {
        return this.levelData.length;
    }

    @Override
    protected LevelStorage getRunLevel(int index) {
        LevelStorageBackend backend = this.levelData[index];
        return LevelStorageBackend.getLevelStorage(backend, this.collectionFunctions);
    }

    @Override
    protected ExpressionRuntime getRuntime() {
        return this.inlineDataRowRuntime;
    }

    @Override
    public LayoutProcess deriveForStorage() {
        try {
            SubLayoutProcess lp = (SubLayoutProcess)super.clone();
            if (this.parent != null) {
                lp.parent = this.parent.deriveForStorage();
            }
            lp.inlineDataRowRuntime = null;
            lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
            for (int i = 0; i < this.collectionFunctions.length; ++i) {
                this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
            }
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public LayoutProcess deriveForPagebreak() {
        try {
            SubLayoutProcess lp = (SubLayoutProcess)super.clone();
            if (this.parent != null) {
                lp.parent = this.parent.deriveForPagebreak();
            }
            lp.inlineDataRowRuntime = null;
            lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
            lp.inlineDataRowRuntime = null;
            for (int i = 0; i < this.collectionFunctions.length; ++i) {
                this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
            }
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Object clone() {
        try {
            SubLayoutProcess lp = (SubLayoutProcess)super.clone();
            if (this.parent != null) {
                lp.parent = (LayoutProcess)this.parent.clone();
            }
            lp.inlineDataRowRuntime = null;
            lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
            lp.inlineDataRowRuntime = null;
            for (int i = 0; i < this.collectionFunctions.length; ++i) {
                this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
            }
            return lp;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    @Override
    public void fireReportEvent(ReportEvent event) {
        InstanceID objectID = event.getReport().getObjectID();
        if (objectID == this.reportDefinitionId) {
            if (this.inlineDataRowRuntime == null) {
                this.inlineDataRowRuntime = new InlineDataRowRuntime();
            }
            ReportState state = this.inlineDataRowRuntime.getState();
            this.inlineDataRowRuntime.setState(event.getState());
            try {
                super.fireReportEvent(event);
            }
            catch (InvalidReportStateException exception) {
                throw exception;
            }
            catch (Throwable t) {
                throw new InvalidReportStateException("Failed to fire report event for sub-layout-process", t);
            }
            finally {
                this.inlineDataRowRuntime.setState(state);
            }
        }
        if (this.parent != null) {
            this.parent.fireReportEvent(event);
        }
    }
}

