/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;

public class LengthLimitingTableModel
implements MetaTableModel {
    private TableModel backend;
    private int queryLimit;
    private MetaTableModel metaBackend;

    public LengthLimitingTableModel(TableModel backend, int queryLimit) {
        if (backend == null) {
            throw new NullPointerException();
        }
        if (queryLimit <= 0) {
            throw new IllegalArgumentException();
        }
        this.backend = backend;
        this.queryLimit = Math.min(queryLimit, backend.getRowCount());
        if (backend instanceof MetaTableModel) {
            this.metaBackend = (MetaTableModel)backend;
        }
    }

    @Override
    public int getRowCount() {
        return this.queryLimit;
    }

    @Override
    public int getColumnCount() {
        return this.backend.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.backend.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.backend.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.backend.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.backend.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.backend.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.backend.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.backend.removeTableModelListener(l);
    }

    @Override
    public DataAttributes getCellDataAttributes(int row, int column) {
        if (this.metaBackend != null) {
            return this.metaBackend.getCellDataAttributes(row, column);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    @Override
    public boolean isCellDataAttributesSupported() {
        if (this.metaBackend != null) {
            return this.metaBackend.isCellDataAttributesSupported();
        }
        return false;
    }

    @Override
    public DataAttributes getColumnAttributes(int column) {
        if (this.metaBackend != null) {
            return this.metaBackend.getColumnAttributes(column);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    @Override
    public DataAttributes getTableAttributes() {
        if (this.metaBackend != null) {
            return this.metaBackend.getTableAttributes();
        }
        return EmptyDataAttributes.INSTANCE;
    }
}

