/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ObjectWriter
extends AbstractXMLDefinitionWriter {
    private static final Log logger = LogFactory.getLog(ObjectWriter.class);
    private ObjectDescription objectDescription;
    private ClassFactoryCollector cc;

    public ObjectWriter(ReportWriterContext reportWriter, Object baseObject, ObjectDescription objectDescription, XmlWriter indentLevel) throws ReportWriterException {
        this(reportWriter, objectDescription, indentLevel);
        if (baseObject == null) {
            throw new NullPointerException("BaseObject is null");
        }
        try {
            objectDescription.setParameterFromObject(baseObject);
        }
        catch (ObjectFactoryException ofe) {
            throw new ReportWriterException("Failed to fill ObjectDescription", ofe);
        }
    }

    public ObjectWriter(ReportWriterContext reportWriter, ObjectDescription objectDescription, XmlWriter indentLevel) {
        super(reportWriter, indentLevel);
        if (objectDescription == null) {
            throw new NullPointerException("ObjectDescription is null");
        }
        this.objectDescription = objectDescription;
        this.cc = this.getReportWriter().getClassFactoryCollector();
    }

    public ObjectDescription getObjectDescription() {
        return this.objectDescription;
    }

    public ClassFactoryCollector getClassFactoryCollector() {
        return this.cc;
    }

    @Override
    public void write() throws IOException, ReportWriterException {
        Iterator names = this.objectDescription.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.writeParameter(name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ObjectDescription getParameterDescription(String name) {
        ObjectDescription parameterDescription;
        Object o = this.objectDescription.getParameter(name);
        if (o != null) {
            parameterDescription = this.cc.getDescriptionForClass(o.getClass());
            if (parameterDescription != null) return parameterDescription;
            parameterDescription = this.cc.getSuperClassObjectDescription(o.getClass(), null);
        } else {
            Class parameterClass = this.objectDescription.getParameterDefinition(name);
            parameterDescription = this.cc.getDescriptionForClass(parameterClass);
            if (parameterDescription != null) {
                return parameterDescription;
            }
            parameterDescription = this.cc.getSuperClassObjectDescription(parameterClass, null);
        }
        if (parameterDescription != null) return parameterDescription;
        logger.info((Object)("Unable to get parameter description for parameter: " + name));
        return parameterDescription;
    }

    protected void writeParameter(String parameterName) throws IOException, ReportWriterException {
        Object parameterValue = this.getObjectDescription().getParameter(parameterName);
        if (parameterValue == null) {
            return;
        }
        Class parameterDefinition = this.getObjectDescription().getParameterDefinition(parameterName);
        ObjectDescription parameterDescription = this.getParameterDescription(parameterName);
        if (parameterDescription == null) {
            throw new ReportWriterException("Unable to get Parameter description for " + this.getObjectDescription().getObjectClass() + " Parameter: " + parameterName);
        }
        try {
            parameterDescription.setParameterFromObject(parameterValue);
        }
        catch (ObjectFactoryException ofe) {
            throw new ReportWriterException("Unable to fill parameter object:" + parameterName, ofe);
        }
        ArrayList parameterNames = ObjectWriter.getParameterNames(parameterDescription);
        if (parameterNames.isEmpty()) {
            return;
        }
        AttributeList p = new AttributeList();
        p.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", parameterName);
        if (!this.isUseParameterObjectDescription(parameterDefinition, parameterValue)) {
            p.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", parameterValue.getClass().getName());
        }
        XmlWriter writer = this.getXmlWriter();
        if (ObjectWriter.isBasicObject(parameterNames, parameterDescription)) {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "basic-object", p, false);
            String valueString = (String)parameterDescription.getParameter("value");
            writer.writeTextNormalized(valueString, false);
            writer.writeCloseTag();
        } else {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "compound-object", p, false);
            ObjectWriter objWriter = new ObjectWriter(this.getReportWriter(), parameterValue, parameterDescription, writer);
            objWriter.write();
            writer.writeCloseTag();
        }
    }

    private boolean isUseParameterObjectDescription(Class parameter, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription odObject = cc.getDescriptionForClass(o.getClass());
        ObjectDescription odParameter = cc.getDescriptionForClass(parameter);
        if (odObject == null) {
            odObject = cc.getSuperClassObjectDescription(o.getClass(), odObject);
        }
        if (odParameter == null) {
            odParameter = cc.getSuperClassObjectDescription(parameter, odParameter);
        }
        return ObjectUtilities.equal((Object)odParameter, (Object)odObject);
    }

    protected static boolean isBasicObject(List parameters, ObjectDescription od) {
        String param;
        if (od == null) {
            throw new NullPointerException();
        }
        return parameters.size() == 1 && "value".equals(param = (String)parameters.get(0)) && od.getParameterDefinition("value").equals(String.class);
    }

    protected static ArrayList getParameterNames(ObjectDescription d) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = d.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (d.getParameter(name) == null) continue;
            list.add(name);
        }
        return list;
    }
}

